#include "mbed.h"
#include "log_data.h"
#include "SDFileSystem.h"
#include "helper_3dmath.h"
#include "debug.h"
#include "SystemTime.h"
#include "pins.h"
#include "main.h"

// SD Card
SDFileSystem sd(P0_9, P0_8, P0_10, P1_19, "sd"); // MOSI, MISO, SCLK, SSEL SPI1

// DS3231 rtc(I2C_SDA, I2C_SCL);

// Logging vars
FILE *accelFile;
//FILE *peakFile;

/* Returns true if logging was successfully initialized, false otherwise */
bool log_init() {
    PC_PRINTLN("Initializing logging...");

    char filename[32];
    // year_month_day_hour_min_sec.log
    int year, month, day, hour, min, sec;
    rtc.readDate(&day, &month, &year);
    rtc.readTime(&hour, &min, &sec);
    sprintf(filename, "/sd/%04d_%02d_%02d_%02d_%02d_%02d.log", year, month, day, hour, min, sec);
    
    PC_PRINTLNF("Trying to open %s...", filename);

    accelFile = fopen(filename, "w");
    if (accelFile == NULL) {
        PC_PRINTLNF("SD card initialization error: Failed to open %s", filename);
        DIE(SD_ERROR_RATE);
        return false;
    }
    
    return true;
}

/* Returns true if data was successfully logged, false otherwise 
   Used for logging acceleration data */
bool log_data(int time_ms, VectorInt16 *data) {
    if (accelFile != NULL) {
//        fprintf(accelFile, "%d, %d, %d, %d\n", time_ms, data->x, data->y, data->z);
        fwrite(&time_ms, sizeof(int), 1, accelFile);
        fwrite(data, sizeof(VectorInt16), 1, accelFile);
        return true;
    }
    
    return false;
}

///* Returns true if data was successfully logged, false otherwise 
//   Used for logging split times */
//bool log_data(int time_ms, int split) {
//    if (peakFile != NULL) {
////        fprintf(peakFile, "%d, %d\n", time_ms, split);
//        fwrite( (void*) &time_ms, sizeof(int), 1, peakFile);
//        fwrite( (void*) &split, sizeof(int), 1, peakFile);
//        return true;
//    }
//    
//    return false;
//}

/* Returns true if logging was successfully closed, false otherwise */
bool log_close() {
//    if (accelFile != NULL && splitFile != NULL)
//        return ( (fclose(accelFile) == 0) && (fclose(splitFile) == 0) );
    
    fclose(accelFile);
//    fclose(peakFile);
    
    return true;
}