#ifndef _COMMS_H
#define _COMMS_H

#include "mbed.h"
#include "MODSERIAL.h"
#include <limits.h>

class Packet;   // forward declaration

class Comms {
    public:
        Comms() : bt(P0_19, P0_18) { bt.baud(115200); }

        int receivePacket(Packet **p, int timeout);
        void sendPacket(Packet *p);
    
    private:
        Timer timer;
        void sendByte(uint8_t byte);
        void sendBytes(uint8_t *bytes, int nElms);
        bool getByte(uint8_t *c, int timeout = INT_MAX);
        bool getBytes(uint8_t *buf, int nElms, int timeout = INT_MAX);
        MODSERIAL bt; // tx, rx
};

class Packet {
    public:
        static Packet *create(uint8_t cmd, uint16_t packetNumber, uint16_t dataLength, uint8_t *data);
        static Packet *createAndVerify(uint8_t cmd, uint16_t packetNumber, uint16_t dataLength, uint8_t *data, uint16_t checkSum);
        ~Packet();
        
        uint8_t cmd;
        uint16_t packetNumber;
        uint16_t dataLength;
        uint8_t *data;
        uint16_t checkSum;
        
        static const int HEADER_SIZE;
    private:
        Packet(uint8_t cmd, uint16_t packetNumber, uint16_t dataLength, uint8_t *data);
};

#endif // _COMMS_H