#include "mbed.h"
#include "network.h"
#include <fstream>
#include <cmath>
#include <queue>
#include "rtos.h"



#define PACKET_COUNT 4

 Serial pc(USBTX, USBRX); // tx, rx
 DigitalOut myled4(LED4);
 DigitalOut myled3(LED3);
 
 LocalFileSystem local("local");
int read_buffer[100][20];


 
 
//Converts the data from the buffer into values
//and puts it in a struct which we can pass to another fn 
control_p set_cp_values(int packet_num){
  
    control_p packet_data;
  
    int bit_idx = 0;
    int sequence = 0;
    int furnace = 0;
    int interval = 0;
    int bit_decrement = 0;
    
    bit_decrement = 3;
    for(; bit_idx < 4; bit_idx++){
        if( read_buffer[packet_num][2 + bit_idx] == 1){ //need to add 2 because starrt bits
             sequence += pow(2.0,bit_decrement); 
             }
        bit_decrement--;
    }
    
    bit_decrement = 3;
    for(; bit_idx < 8; bit_idx++){
        if( read_buffer[packet_num][2 + bit_idx] == 1){ 
             furnace += pow(2.0,bit_decrement); 
             }
        bit_decrement--;
    }
    
      bit_decrement = 6;
    for(; bit_idx < 18; bit_idx++){
        if( read_buffer[packet_num][2 + bit_idx] == 1){ 
             interval += pow(2.0,bit_decrement); 
             }
        bit_decrement--;
    }
    
  //  packet_data.sequence = sequence;
   // packet_data.furnace = furnace;
   // packet_data.interval = interval;
    
    return packet_data;
    

     
    
     
}
 
 
std::queue<vector<int> > buffer;
vector<int> numbers;

std::queue<string> buffer2;
std::queue<vector<char> > buffer3;

Queue<char*, 7> buffer4;


int main() {
    char* a;

    myled4 = 1;
    
    int idx = 0; 
    int num_packets = 0;
   
    FILE *fp = fopen("/local/packet.txt", "w"); 
    for(num_packets=0; num_packets < PACKET_COUNT; num_packets++){
        
        a = (char *) malloc(sizeof(char) * 21);
        
        if(a==NULL){
            myled3 = 1; 
            return 1;
        }
          
        if(fp==NULL){
            myled3 = 1; 
            fclose(fp);
            return 1;  
        }
        for(idx=0; idx < 19; idx++){
            a[idx] = char(pc.getc());
            if(num_packets==1)myled3 = 1; 
            fprintf(fp,"%c",a[idx]);    
            if(idx == 1)
                fprintf(fp,".");
            if(idx == 5)
                fprintf(fp,".");
            if(idx == 9)
                fprintf(fp,".");
            if(idx == 16)
                fprintf(fp,".");
            if(idx == 18)
                fprintf(fp,".");
        }
        a[19]=0;
        
        idx = 0;
        fprintf(fp,"\n");

        
        buffer4.put((char**)&a[0]);
        
        osEvent evt = buffer4.get();
        if (evt.status != osEventMessage) {
            printf("Furnace: queue->get() returned %02x status\n\r", evt.status);
        } else {
            fprintf(fp,"Queue: %s\n\r",evt.value.v);
            //printf("Furnace: %s", evt.value.v);
        }
        free(a);
    }
    //fclose(fp);
    fclose(fp);
    return 0;
    
}





