
#define MAGNETO_ADDRESS 0x3C

// Register Address (RA)
#define MAGNETO_RA_CONFIG_A 0x00
#define MAGNETO_RA_CONFIG_B 0x01
#define MAGNETO_RA_MODE     0x02
#define MAGNETO_RA_X_MSB    0x03
#define MAGNETO_RA_X_LSB    0x04
#define MAGNETO_RA_Z_MSB    0x05
#define MAGNETO_RA_Z_LSB    0x06
#define MAGNETO_RA_Y_MSB    0x07
#define MAGNETO_RA_Y_LSB    0x08
#define MAGNETO_RA_STATUS   0x09
#define MAGNETO_RA_ID_A     0x0A
#define MAGNETO_RA_ID_B     0x0B
#define MAGNETO_RA_ID_C     0x0C


// Configuration Register A (CRA)
#define CRA_SAMPLE_AVG_BIT 5
#define CRA_SAMPLE_AVG_1   0x00
#define CRA_SAMPLE_AVG_2   0x01
#define CRA_SAMPLE_AVG_4   0x02
#define CRA_SAMPLE_AVG_8   0x03

#define CRA_DATA_RATE_BIT  2
#define CRA_DATA_RATE_0_75 0x00
#define CRA_DATA_RATE_1_5  0x01
#define CRA_DATA_RATE_3    0x02
#define CRA_DATA_RATE_7_5  0x03
#define CRA_DATA_RATE_15   0x04
#define CRA_DATA_RATE_30   0x05
#define CRA_DATA_RATE_75   0x06

#define CRA_MEAS_MODE_BIT 0
#define CRA_MEAS_NORMAL   0x00
#define CRA_MEAS_BIAS_P   0x01
#define CRA_MEAS_BIAS_N   0x02

// Configuration Register B (CRB)
#define CRB_GAIN_BIT 5
#define CRB_GAIN_088 0x00
#define CRB_GAIN_130 0x01
#define CRB_GAIN_190 0x02
#define CRB_GAIN_250 0x03
#define CRB_GAIN_400 0x04
#define CRB_GAIN_470 0x05
#define CRB_GAIN_560 0x06
#define CRB_GAIN_810 0x07

// Mode Register (MR)
#define MR_MODE_BIT        0
#define MR_MODE_CONTINUOUS 0x00
#define MR_MODE_SINGLE     0x01
#define MR_MODE_IDLE_2     0x02
#define MR_MODE_IDLE_3     0x03

// Output Registers (OR)
#define OR_MIN_VALUE 0xFC00
#define OR_MAX_VALUE 0x03FF

// Status Register (SR)
#define SR_LOCK_BIT 1
#define SR_RDY_BIT  0

// Identification Register A-C (IR)
#define IR_A_VALUE 'H'
#define IR_B_VALUE '4'
#define IR_C_VALUE '3'
