#ifndef MAGNETO_H
#define MAGNETO_H

#include "mbed.h"
#include "MagnetoRegisterMap.h"

#define HEADING_ERROR -400

class Magneto{
public:
    Magneto(I2C & i2c);
    ~Magneto() {}
    
    bool TestDeviceConnection();
    
    void ActivateDevice();
    
    void ReadXZY(int16_t * raw);
    
    // Return the heading in degrees from 0 to 360
    int16_t GetHeadingXY();
    
    void ResetDevice();
    
private:
    I2C * _i2c;
    
    Magneto();
    Magneto(const Magneto&);
    Magneto& operator=(const Magneto&);
};

#endif