#ifndef ACC_H
#define ACC_H

#include "mbed.h"
#include "AccRegisterMap.h"

class Acc{
public:
    Acc(I2C& i2c);
    ~Acc() {}
    
    bool TestDeviceConnection();
    
    void ActivateDevice();
    
    void ReadXYZ(int16_t * raw);
    
    // Return the inclination in degrees from -90 to 90
    int16_t GetInclinationYZ();
    
private:
    I2C * _i2c;
    
    Acc();
    Acc(const Acc &);
    Acc & operator=(const Acc &);
};

#endif