#include "Acc.h"

#define PI                3.14159265358979323f

namespace {
    char cmd[2];
    char buffer[6];
};

Acc::Acc(I2C& i2c) :
_i2c(&i2c)
{
}

bool Acc::TestDeviceConnection(){
    cmd[0] = ACC_RA_WHO_AM_I;
    _i2c->write(ACC_ADDRESS, cmd, 1, true);
    _i2c->read(ACC_ADDRESS, buffer, 1);
    
    return buffer[0] == WAIR_VALUE;
}

void Acc::ActivateDevice(){
    cmd[0] = ACC_RA_CTRL_REG1;
    cmd[1] = (1 << CR1_ACTIVE_BIT);
    
    _i2c->write(ACC_ADDRESS, cmd, 2, false);
}

void Acc::ReadXYZ(int16_t* raw){
    cmd[0] = ACC_RA_X_MSB;
    
    _i2c->write(ACC_ADDRESS, cmd, 1, true);
    _i2c->read(ACC_ADDRESS, buffer, 6);
    
    for(int i = 0; i < 6; i+=2){
        int16_t value = buffer[i];
        value = (value << 8) | buffer[i+1];
        value >>= 4;
        raw[i>>1] = value;
    }
}

int16_t Acc::GetInclinationYZ(){
    int16_t data[3];
    
    ReadXYZ(data);
    
    //int16_t x = data[0];
    int16_t y = data[1];
    int16_t z = data[2];
    
    int16_t theta = atan2((float)y,(float)z) * 180.0f / PI;
    
    return theta;
}