#include "global.h"
#include <string.h>
#include <sstream>
#include <math.h>
#include <vector>


#define M_PI 3.14159265358979323846
#define VERT 0xFF00FF00
#define ROUGE 0xFFFF0000
#define BLEU 0xFF0000FF
#define JAUNE 0xFFFDD835//FEFE00
#define BLANC 0xFF000000
#define ORANGE 0xFFFFA500
#define NOIR 0xFF000000
#define DIY_GREY 0xFFDFDFDF
#define VIOLET 0xFF4527A0

int waitingAckID_FIN;
int waitingAckFrom_FIN;

Ticker ticker;
TS_DISCO_F469NI ts;
LCD_DISCO_F469NI lcd;

TS_StateTypeDef TS_State;

char counter = 0;
char check;
char Jack = 1;

unsigned char isStopEnable = 1;//Permet de savoir si il faut autoriser le stop via les balises
int flag = 0, flag_strat = 0, flag_timer;
char Ack_strat = 0;
signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN

//unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN
int flagSendCan=1;
unsigned char Cote = 0; //0 -> JAUNE | 1 -> VIOLET
unsigned char checkCurrent = 0;
unsigned char countAliveCard = 0;
unsigned char ligne=0;

unsigned char countRobotNear = 0;//Le nombre de robot à proximité

unsigned char ingnorBaliseOnce = 0;//une fois détecté réinitialise
unsigned char ingnorBalise = 0;//0:balise ignore 1:on ecoute la balise
short direction;

unsigned char ingnorInversionOnce = 0;//Pour ignorer l'inversion des instruction une fois


typedef enum {INIT, ATT, CHOIX, DEMO,TEST_TELEMETRE, TEST_COULEUR, TEST_SERVO_BRAS} T_etat;
T_etat etat = INIT;
E_Stratposdebut etat_pos=RECALAGE_1;

/////////////////DEFINITION DES BOUTONS////////////////////
Button RETOUR  (0, 680, 400, 110, "--Precedent--");
Button LANCER  (0, 200, 400, 200, "--LANCER--");
Button CHECK (0, 420, 400, 200, "Valider");
Button DEMONSTRATION (0, 400, 400, 320, "Demo");
//menu demo
Button TEST_COUL(0,245,400,100,"Test capteurs couleur");
Button TEST_BRAS(0,355,400,100,"Test Bras");
Button TEST_TELEM(0,465,400,100,"Test telemetre");
//menu demo/demo/
Button TEST_NUM(0,245,400,100,"Bras num");
Button TEST_PLUS(205,355,195,100,"+");
Button TEST_MOINS(0,355,195,100,"-");


Button FORCE_LAUNCH(0, 50, 400, 320, "Force Launch");
Button SUIVANT(0,380,200,100,"Suivant");
////////////////////////////////////////////////////////////

void SendRawId (unsigned short id);
void SelectionStrat (unsigned char numeroStrat);
void Setflag(void);
void can2Rx_ISR(void);

unsigned char DT_AVD_interrupt=0;
unsigned char DT_AVG_interrupt=0;
unsigned char DT_ARD_interrupt=0;
unsigned char DT_ARG_interrupt=0;

unsigned short id_check[NOMBRE_CARTES]= {CHECK_MOTEUR,CHECK_BALISE};
unsigned short id_alive[NOMBRE_CARTES]= {ALIVE_MOTEUR,ALIVE_BALISE};
InterruptIn jack(PG_11); //  entrée numerique en interruption pour le jack

void Setflag(void)
{
    flagSendCan = 1;//gab le zgeg
}


/****************************************************************************************/
/* FUNCTION NAME: automate_etat_ihm                                                     */
/* DESCRIPTION  : Automate de gestion de l'affichage                                    */
/****************************************************************************************/
void automate_etat_ihm(void)
{
    char toto[2]; 
    int j;
    unsigned char maximilien=1;
    if (j==0) 
    {
        ts.Init(lcd.GetXSize(), lcd.GetYSize());
        j++;
    }
    ts.GetState(&TS_State);
    
    switch (etat) {
        case INIT : //intialise l'écran et passe à l'attente d'initialisation des cartes
            ts.GetState(&TS_State);
            canProcessRx();
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.Clear (LCD_COLOR_WHITE);
            wait(0.15);
            lcd.DisplayStringAt(0, 10, (uint8_t *)"Verification des cartes", LEFT_MODE);
            //cartes non verifiées////////////////
            lcd.SetTextColor(DIY_GREY);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.SetBackColor(DIY_GREY);
            lcd.DisplayStringAt(80, 450, (uint8_t *)"Carte Moteur", LEFT_MODE);
            lcd.DisplayStringAt(110,650, (uint8_t *)"Balise", LEFT_MODE);

            etat=ATT;
            break;

        case ATT :  //Si les cartes sont présentes passe directement à choix sinon attente de force Launch (cette partie est encore buggée mais les cartes affichent bien leur présence donc faut juste force launch tout le temps...)
            if (flag==0) {
                etat = CHOIX;
            } else if (FORCE_LAUNCH.Touched()) {
                etat = CHOIX;
                while(FORCE_LAUNCH.Touched());
            }
            break;


        case CHOIX :    //Match ou DEMO
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.Clear (LCD_COLOR_WHITE);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Match ou demonstration ?", LEFT_MODE);
            DEMONSTRATION.Draw(LCD_COLOR_LIGHTGREEN, 0);
            while(etat == CHOIX) {
                canProcessRx();
                if(DEMONSTRATION.Touched()) {
                    etat = DEMO;
                    while(DEMONSTRATION.Touched());
                }
            }
            break;

        case DEMO :
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.Clear (LCD_COLOR_WHITE);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"DEMO", LEFT_MODE);
            RETOUR.Draw(0xFFFF0000, 0);
            TEST_COUL.Draw(VERT, 0);
            TEST_BRAS.Draw(VERT, 0);
            maximilien=0;
            while (etat == DEMO) {
                canProcessRx();
                if (TEST_COUL.Touched()) {
                    while(TEST_COUL.Touched());
                    etat =TEST_COULEUR ;
                } else if (TEST_BRAS.Touched()) {
                    while(TEST_BRAS.Touched());
                    etat =TEST_SERVO_BRAS ;
                }
            }
            break;
            
        case TEST_SERVO_BRAS:    
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.Clear (LCD_COLOR_WHITE);   
            lcd.Clear (LCD_COLOR_WHITE);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Test Bras", LEFT_MODE);
            sprintf(toto,"%hd",maximilien);
            lcd.DisplayStringAt(50, LINE(20), (unsigned char *)toto, LEFT_MODE);
            RETOUR.Draw(0xFFFF0000,0);
            TEST_NUM.Draw(BLEU, BLANC);
            TEST_PLUS.Draw(BLEU, BLANC);
            TEST_MOINS.Draw(BLEU, BLANC);
            while(etat==TEST_SERVO_BRAS) {
                if(RETOUR.Touched()) {
                    while (RETOUR.Touched());
                    etat=DEMO;
                } else if(TEST_NUM.Touched()) {
                    while (TEST_NUM.Touched());
                    TEST_NUM.Draw(BLEU, BLANC);
                    switch(maximilien){
                    case 1:
                    SendRawId(TEST_BRAS_1);
                    break;
                    case 2:
                    SendRawId(TEST_BRAS_2);
                    break;
                    case 3:
                    SendRawId(TEST_BRAS_3);
                    break;
                    case 4:
                    SendRawId(TEST_BRAS_4);
                    break;
                    case 5:
                    SendRawId(TEST_BRAS_5);
                    break;
                    }
                } else if(TEST_PLUS.Touched()) {
                    while (TEST_PLUS.Touched());
                    TEST_PLUS.Draw(BLEU, BLANC);
                    if(maximilien!=5)maximilien++;
                    sprintf(toto,"%hd",maximilien);
                    lcd.SetBackColor(LCD_COLOR_WHITE);
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.DisplayStringAt(50, LINE(20), (unsigned char *)toto, LEFT_MODE);
                } else if(TEST_MOINS.Touched()) {
                    while (TEST_MOINS.Touched());
                    TEST_MOINS.Draw(BLEU, BLANC);
                    if(maximilien!=1)maximilien--;
                    sprintf(toto,"%hd",maximilien);
                    lcd.SetBackColor(LCD_COLOR_WHITE);
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.DisplayStringAt(50, LINE(20), (unsigned char *)toto, LEFT_MODE);
                }
            }
            break;
            
        case TEST_TELEMETRE:   
            lcd.SetBackColor(LCD_COLOR_WHITE);
            lcd.SetTextColor(LCD_COLOR_BLACK);
            lcd.Clear (LCD_COLOR_WHITE);   
            lcd.Clear (LCD_COLOR_WHITE);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Test Telemetre", LEFT_MODE);
            sprintf(toto,"%hd",maximilien);
            lcd.DisplayStringAt(50, LINE(20), (unsigned char *)toto, LEFT_MODE);
            RETOUR.Draw(0xFFFF0000,0);
            TEST_NUM.Draw(BLEU, BLANC);
            TEST_PLUS.Draw(BLEU, BLANC);
            TEST_MOINS.Draw(BLEU, BLANC);
            while(etat==TEST_TELEMETRE) {
                if(RETOUR.Touched()) {
                    while (RETOUR.Touched());
                    etat=DEMO;
                } else if(TEST_NUM.Touched()) {
                    while (TEST_NUM.Touched());
                    TEST_NUM.Draw(BLEU, BLANC);
                    switch(maximilien){
                    case 1:
                    SendRawId(TEST_TELEMETRE_1);
                    break;
                    case 2:
                    SendRawId(TEST_TELEMETRE_2);
                    break;
                    case 3:
                    SendRawId(TEST_TELEMETRE_3);
                    break;
                    case 4:
                    SendRawId(TEST_TELEMETRE_4);
                    break;
                    }
                } else if(TEST_PLUS.Touched()) {
                    while (TEST_PLUS.Touched());
                    TEST_PLUS.Draw(BLEU, BLANC);
                    if(maximilien!=5)maximilien++;
                    sprintf(toto,"%hd",maximilien);
                    lcd.SetBackColor(LCD_COLOR_WHITE);
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.DisplayStringAt(50, LINE(20), (unsigned char *)toto, LEFT_MODE);
                } else if(TEST_MOINS.Touched()) {
                    while (TEST_MOINS.Touched());
                    TEST_MOINS.Draw(BLEU, BLANC);
                    if(maximilien!=1)maximilien--;
                    sprintf(toto,"%hd",maximilien);
                    lcd.SetBackColor(LCD_COLOR_WHITE);
                    lcd.SetTextColor(LCD_COLOR_BLACK);
                    lcd.DisplayStringAt(50, LINE(20), (unsigned char *)toto, LEFT_MODE);
                }
            }
            break;
        
        case TEST_COULEUR:      
            lcd.Clear (LCD_COLOR_WHITE);
            lcd.DisplayStringAt(0, LINE(0), (uint8_t *)"Test Couleur", LEFT_MODE);
            RETOUR.Draw(0xFFFF0000,0);
            while(etat==TEST_COULEUR) {
                if(RETOUR.Touched()) {
                    while (RETOUR.Touched());
                    etat=DEMO;
                    lcd.Clear (LCD_COLOR_WHITE);
                } 
            }
            break;
        }

}

/****************************************************************************************/
/* FUNCTION NAME: canProcessRx                                                          */
/* DESCRIPTION  : Fait évoluer l'automate de l'IHM en fonction des receptions sur le CAN*/
/****************************************************************************************/
void canProcessRx(void)
{
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;

    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;

    if(FIFO_max_occupation<FIFO_occupation) 
    {
        FIFO_max_occupation=FIFO_occupation;
    }

    if(FIFO_occupation!=0) {
        int identifiant=msgRxBuffer[FIFO_lecture].id;

        if (waitingId == identifiant) waitingId = 0;
        switch(identifiant) {

            case RESET_IHM:
                etat = CHOIX;
                break;
            case TELEMETRE_1_REP:
                break;
                
            case TELEMETRE_2_REP:
                break;
                
            case TELEMETRE_3_REP:
                break;
            
            case TELEMETRE_4_REP:
                break;

            default:
                break;
        }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
}