#include "mbed.h"
#include "global.h"
#include <CAN.h>

CAN can1(PB_8,PB_9); // Rx&Tx pour le CAN
CAN can2(PB_5, PB_13);

DigitalIn choix_robot(PG_12);
CANMessage msgRxBuffer[SIZE_FIFO];
unsigned char FIFO_ecriture;

Serial rn42_pr(PG_14, PG_9);
Serial rn42_Tx(PA_2,NC);
Serial rn42_Rx(NC,PA_1);

Serial pc(USBTX,USBRX);

unsigned short waitingAckID=0;//L'id du ack attendu
unsigned short waitingAckFrom=0;//La provenance du ack attendu
unsigned short waitingId=0;

DigitalOut led1(LED1);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led2(LED2);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led3(LED3);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led4(LED4);//Led d'indication de problème, si elle clignote, c'est pas bon

/****************************************************************************************/
/* FUNCTION NAME: canRx_ISR                                                             */
/* DESCRIPTION  : Interruption en réception sur le CAN                                  */
/****************************************************************************************/
void canRx_ISR (void)
{
    if (can2.read(msgRxBuffer[FIFO_ecriture])) {
        //if(msgRxBuffer[FIFO_ecriture].id==RESET_STRAT) mbed_reset();
        /*else*/ FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
        //canProcessRx();
    }
}

/**********************************************************************************/
/* FUNCTION NAME: main                                                            */
/* DESCRIPTION  : Fonction principal du programme                                 */
/**********************************************************************************/
int main(){
    
    can1.frequency(1000000); // fréquence de travail 1Mbit/s
    can2.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    can2.frequency(1000000);
    
    led1 = 1;
    led1 = 0;
    wait_ms(200);//Attente pour que toutes les cartes se lancent et surtout le CANBlue
    while(true) 
    {
        automate_etat_ihm();
        //canProcessRx();
    }
}