#ifndef CRAC_IDENTH
#define CRAC_IDENTH
 
#define GLOBAL_GAME_END 0x004  // Stop fin du match
#define GLOBAL_START 0x002  // Start
#define GLOBAL_END_INIT_POSITION 0x005  // Fin positionnement robot avant depart
#define GLOBAL_JACK 0x008
#define ACKNOWLEDGE_JACK 0X009
#define RECALAGE_START 0x010//on a commencé le recalage de début
 
#define BALISE_STOP 0x003  // Trame stop
 
#define BALISE_DANGER 0xA  // Trame danger
 
#define BALISE_END_DANGER 0xB  // Trame fin de danger
 
 
#define ASSERVISSEMENT_ERROR_MOTEUR 0x025  // robot s'arrete car percuté quelque chose
 
//------------------------------------Asservissement -------------------------------------------------------------
 
#define ASSERVISSEMENT_ENABLE 0x1F7  // Activation asservissement  (0 : désactivation, 1 : activation)
 
 
#define ASSERVISSEMENT_STOP 0x001  // Stop moteur
#define ASSERVISSEMENT_XYT 0x020  // Asservissement (x,y,theta)  (0 : au choix 1 : avant -1 : arrière)
#define ASSERVISSEMENT_XYT_ROTATE 0x030//premiere rotation durant xy theta
#define ASSERVISSEMENT_XYT_LINE 0x040//ligne droite durant xy theta
#define ASSERVISSEMENT_COURBURE 0x021  // Asservissement rayon de courbure  (+ gauche, - droite , sens : 1avt , -1arr; enchainement => 1 oui, 0 => non, 2=>derniére instruction de l'enchainement)
#define ASSERVISSEMENT_ROTATION 0x023  // Asservissement rotation
#define ASSERVISSEMENT_RECALAGE 0x024  // Moteur tout droit  (recalage : 0 mouvement seul, 1 x, 2y valeur : coordonnée à laquelle est recalé x/y; enchainement => 1 oui, 0 => non)
#define ASSERVISSEMENT_BEZIER 0x02A
   
   
#define ODOMETRIE_BIG_VITESSE 0x027  // Odométrie vitesse  (Indication sur l'état actuel)
#define ODOMETRIE_SMALL_VITESSE 0x027  // Odométrie vitesse  (Indication sur l'état actuel)
 
#define ODOMETRIE_BIG_POSITION 0x028  // Odométrie position robot  (Position actuel du robot)
#define ODOMETRIE_SMALL_POSITION 0x026  // Odométrie position robot  (Position actuel du robot)
 
//#define ODOMETRIE 0x026  // Odométrie position robot  (Position actuel du robot)
//#define ODOMETRIE_DBUG 0x028  // Odométrie position robot  (Position actuel du robot) 
 
 
 
 
#define ASSERVISSEMENT_CONFIG 0x022  // Asservissement paramètre  (définir les valeurs de vitesse max et d'eccélération max)
 
#define ASSERVISSEMENT_CONFIG_VIT 0x031 
#define ASSERVISSEMENT_CONFIG_ACCEL 0x032 
 
#define ASSERVISSEMENT_SPEED_DANGER 0x006  // Vitesse de danger
 
 
#define ASSERVISSEMENT_INFO_CONSIGNE 0x1F0  // Info Consigne et Commande moteur
#define ASSERVISSEMENT_CONFIG_KPP_DROITE 0x1F1  // Config coef KPP_Droit
#define ASSERVISSEMENT_CONFIG_KPI_DROITE 0x1F2  // Config coef KPI_Droit
#define ASSERVISSEMENT_CONFIG_KPD_DROITE 0x1F3  // Config coef KPD_Droit
#define ASSERVISSEMENT_CONFIG_KPP_GAUCHE 0x1F4  // Config coef KPP_Gauche
#define ASSERVISSEMENT_CONFIG_KPI_GAUCHE 0x1F5  // Config coef KPI_Gauche
#define ASSERVISSEMENT_CONFIG_KPD_GAUCHE 0x1F6  // Config coef KPD_Gauche
 
#define ASSERVISSEMENT_CONFIG_KPP 0x710  // Config coef KPP
#define ASSERVISSEMENT_CONFIG_KPI 0x711  // Config coef KPI
#define ASSERVISSEMENT_CONFIG_KPD 0x712  // Config coef KPD
#define ASSERVISSEMENT_CONFIG_LARG 0x713
#define ASSERVISSEMENT_CONFIG_PERIM 0x714
#define ASSERVISSEMENT_CONFIG_COEF_G 0x715
#define ASSERVISSEMENT_CONFIG_COEF_D 0x716
 
                //--------------Débug asserv --------
       
#define ASSERVISSEMENT_ERREUR 0x025    
    
#define ID_FIN_CLOTHO 0x501
 
 
    
#define ID_ENTRAXE 0x510
#define ID_RAYON 0x511
#define ID_ALPHA 0x512
#define ID_VITESSE 0x513
#define ID_ACCELERATION 0x514
#define ID_TCLOTHO 0x515
#define ID_TARC 0x516
#define ID_TEMPS 0x517
#define ID_VIT 0x518
#define ID_VIT1 0x519
#define ID_POS 0x520
#define ID_POS1 0x521
#define ID_T_CALCUL 0x522
 
    
#define ERREUR_TEMP_CALCUL 0x5A0
 
#define ID_DBUG_ETAT 0x5A1
#define ID_DBUG_ETAT_DPL 0x5A2
    
    
#define ID_DBUG_LIGNE_TPS 0x5A3
#define ID_DBUG_LIGNE_PCONS 0x5A4
#define ID_DBUG_LIGNE_VIT 0x5A5
#define ID_DIST_TIC_GENE 0x5A6  
#define ID_TEMPS_CALCUL_CLOTHO 0x5A7
#define ID_DBUG_LIGNE_GENE_VIT 0x5A8
#define ID_CLOTHO_IMPOSSIBLE 0x5A9
    
#define ID_TRAIT_LIGNE_GENE 0x5C0
#define ID_TRAIT_CLOTHO 0x5C1
#define ID_TRAIT 0x5C2
    
#define ID_TEMPS_LONG_1 0x5C3
#define ID_TEMPS_LONG_2 0x5C4
    
#define ID_TEST_VITESSE 0x5C5
    
#define ID_REACLLAGE_AVANT 0x5C6
 
//////////////////////////////////////////////////////////RESETS///////////////////////////////////////////////////
#define RESET_BALISE 0x030  // Reset balise
#define RESET_MOTEUR 0x031  // Reset moteur
#define RESET_IHM 0x032  // Reset écran tactile
#define RESET_ACTIONNEURS 0x033  // Reset actionneurs
#define RESET_POMPES 0x034  // Reset pompes
#define RESET_AX12 0x035  // Reset AX12
#define RESET_TELEMETRE 0x036 // Reset telemetre
 
 
#define RESET_STRAT 0x3A  // Reset stratégie
 
//////////////////////////////////////////////////////////CHECK CARTES/////////////////////////////////////////////////
#define CHECK_BALISE 0x060  // Check balise
#define CHECK_MOTEUR 0x061  // Check moteur
#define CHECK_IHM 0x062  // Check écran tactile
#define CHECK_ACTIONNEURS_AVANT 0x063  // Check actionneurs
#define CHECK_ACTIONNEURS_ARRIERE 0x064  // Check pompes
#define CHECK_AX12 0x065  // Check AX12
#define CHECK_OK_TELEMETRE 0x066 // Check telemetre
 
//////////////////////////////////////////////////////////ACK CARTES///////////////////////////////////////////////////
#define ALIVE_BALISE 0x070  // Alive balise
#define ALIVE_MOTEUR 0x071  // Alive moteur
#define ALIVE_IHM 0x072  // Alive écran tactile
#define ALIVE_ACTIONNEURS_AVANT 0x073  // Alive actionneurs
#define ALIVE_ACTIONNEURS_ARRIERE 0x074  // Alive pompes
#define ALIVE_AX12 0x075  // Alive AX12
#define ALIVE_TELEMETRE 0x076 // Alive telemetre
 
 
/////////////////////////////////////////////////////ACTIONS COMPLEXES/////////////////////////////////////////////////
#define MONTER_IMMEUBLE_DOUBLE 0x090  // Monte deux immeubles selon un code couleur
#define MONTER_IMMEUBLE 0x091
#define ACK_ACTION 0x99 //autre action possible via les herkulex, ne peut pas passer en sendrawid
 
/////////////////////////////////////////////////////////ACKS////////////////////////////////////////////////////////////
#define ACKNOWLEDGE_BALISE 0x100  // Acknowledge balise
#define ACKNOWLEDGE_MOTEUR 0x101  // Acknowledge moteur
#define ACKNOWLEDGE_IHM 0x102  // Acknowledge ecran tactile
#define ACKNOWLEDGE_ACTIONNEURS 0x103  // Acknowledge actionneurs
#define ACKNOWLEDGE_TELEMETRE 0x105 // Acknowledge telemetre
#define ACKNOWLEDGE_HERKULEX 0x106 // Ack ax12
#define ACKNOWLEDGE_STRAT 0x10A  // Acknowledge pompes
#define ACKNOWLEDGE_CAMERA 0x108 //Acknowledge couleur caméra
 
 
#define INSTRUCTION_END_BALISE 0x110  // Fin instruction balise  (Indique que l'instruction est terminée)
#define INSTRUCTION_END_MOTEUR 0x111  // Fin instruction moteur  (Indique que l'instruction est terminée)
#define INSTRUCTION_END_IHM 0x112  // Fin instruction ecran tactile  (Indique que l'instruction est terminée)
#define INSTRUCTION_END_ACTIONNEURS 0x113  // Fin instruction actionneurs  (Indique que l'instruction est terminée)
#define ACK_FIN_ACTION 0x116
 
 
 
/////////////////////////////////////////////////////////ERREURS////////////////////////////////////////////////////////
#define ERROR_OVERFLOW_BALISE 0x040  // Overflow odométrie
#define ERROR_OVERFLOW_MOTEUR 0x041  // Overflow asservissement
#define ERROR_OVERFLOW_IHM 0x042  // Overflow balise
#define ERROR_OVERFLOW_STRAT 0x043  // Overflow stratégie
#define ERROR_BALISE 0x785  // Bug balise
#define ERROR_RTC 0x786  // Bug RTC
#define ERROR_MOTEUR 0x787  // Bug moteur
#define ERROR_TELEMETRIE 0x788  // Bug télémètre
#define ERROR_STRATEGIE 0x789  // Bug stratégie
 
  
/////////////////////////////////////////////////ACTIONS SIMPLES DU ROBOT/////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define ACCELERATEUR_INSERTION_AVANT_GAUCHE 0X218
#define ACCELERATEUR_INSERTION_ARRIERE_GAUCHE 0X219
 
 
///////////////////////////////////////////CAPTEURS///////////////////////////////////////////////////////////////////
#define DATA_TELEMETRE 0x3B0        // Demande sa valeur à un télémètre parmis les 
#define RECEPTION_DATA 0x3B1        // envoi de la valeur d'un des télémètres
#define TELEMETRE_OBJET 0x3B2
#define OBJET_SUR_TABLE 0x3B3
#define RECEPTION_RECALAGE 0x3B5    //Valeur des télémètres 
#define DATA_RECALAGE 0x3B6         //Demande de la valeur de tous les télémètres afin de procèder au récalage
#define LIRE_PANNEAU 0x3B7
#define VIBRO 0x3B8
 
#define DATA_TELEMETRE_LOGIQUE 0x3B9
#define RECEPTION_TELEMETRE_LOGIQUE 0x3B0

///////////////////////////////////////////////////ENVOI DE PARAMETRES//////////////////////////////////////////////////
#define CHOICE_COLOR 0x602  // Couleur  (0->VERT;1->ORANGE)
#define RECEPTION_COULEUR 0x603 //Code Couleur
#define ECRAN_ALL_CHECK 0x620  // Carte all check  (Si provient de carte strat => toutes les cartes sont en ligne, Si provient IHM => forcer le lancement)
 
///////////////////////////////////////////////////////////DEBUGS///////////////////////////////////////////////////////
#define DEBUG_STRATEGIE_AUTOMATE 0x760  // Etat automate stratégie  (Permet de savoir l'etat de l'automate)
#define DEBUG_FAKE_JAKE 0x761  // Fake jack  (Permet d'outre passerr le JACk du robot)
#define DEBUG_ASSERV 0x762  // Info debug carte moteur

 
//////////////////////////////////////////////////////////ACK CARTES///////////////////////////////////////////////////
#define ALIVE_BALISE 0x070  // Alive balise
#define ALIVE_MOTEUR 0x071  // Alive moteur
#define ALIVE_IHM 0x072  // Alive écran tactile
#define ALIVE_ACTIONNEURS_AVANT 0x073  // Alive actionneurs
#define ALIVE_ACTIONNEURS_ARRIERE 0x074  // Alive pompes
#define ALIVE_HERKULEX 0x075  // Alive AX12
#define ALIVE_TELEMETRE 0x076 // Alive telemetre
 
//////////////////////////////////////bras//////////////////////////////////////
#define TEST_TELEMETRE_1 0x280
#define TEST_TELEMETRE_2 0x281
#define TEST_TELEMETRE_3 0x282
#define TEST_TELEMETRE_4 0x283

#define TELEMETRE_1_REP 0x284
#define TELEMETRE_2_REP 0x285
#define TELEMETRE_3_REP 0x286
#define TELEMETRE_4_REP 0x287
//ces tests permettent de tester les bras pour attraper puis relacher directement
#define TEST_BRAS_1 0x254
#define TEST_BRAS_2 0x255
#define TEST_BRAS_3 0x256
#define TEST_BRAS_4 0x257
#define TEST_BRAS_5 0x258
#define TEST_BRAS_6 0x259

///////////////////////define des bras stratégie////////////////////////////////
#define BRAS_AT 0x260
#define BRAS_RE 0x261

////////////////////////////////////// ventouse/électrovanne //////////////////////////////////
//les ventouses fonctionnent avec les électrovannes
#define VENT_AT 0x266
#define VENT_RE 0x267
//-----------------------------------define bras/ventouse valeur--------------------------//
#define AV_DROIT    0
#define AV_CENTRE   1
#define AV_GAUCHE   2
 
#define AR_DROIT    3
#define AR_CENTRE   4
#define AR_GAUCHE   5

#endif