#ifndef GLOBAL_H
#define GLOBAL_H

#include "mbed.h"
#include "ident_crac.h"


#include <CAN.h>
#include <DirHandle.h>
#include "conv_data.h"
#include "constantes.h"
#include "Strategie.h"
#include "SerialHalfDuplex.h"
#include "Asservissement.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "fonts.h"
#include "F469_GUI.hpp"

//#include "peripheriques.h"
extern Serial pc;
extern Serial rn42_Tx;
extern Serial rn42_Rx;
extern Serial rn42_pr;

extern CAN can1;
extern CAN can2;
extern CANMessage msgRxBuffer[SIZE_FIFO];
extern unsigned char FIFO_ecriture;

extern signed char Strategie;

extern int ack_bluetooth;

extern DigitalOut led1,led2,led3,led4;
extern LCD_DISCO_F469NI lcd;

extern struct S_Instruction strat_instructions[SIZE_BUFFER_FILE]; //La liste des instruction chargé en mémoire
extern unsigned char nb_instructions; //Le nombre d'instruction dans le fichier de strategie
extern unsigned char actual_instruction;//La ligne de l'instruction en cours d'execution

extern char couleur1, couleur2, couleur3;
extern unsigned char InversStrat;//Si à 1, indique que l'on part de l'autre cote de la table(inversion des Y)

extern unsigned short waitingAckID;//L'id du ack attendu
extern unsigned short waitingAckFrom;//La provenance du ack attendu
extern unsigned short waitingId;

extern unsigned char isStopEnable;
#endif