#include "Asservissement.h"

/*********************************************************************************************************/
/* FUNCTION NAME: SendRawId                                                                              */
/* DESCRIPTION  : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendRawId (unsigned short id)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=0;
    can2.write(msgTx);
    wait_us(200);
}

/*********************************************************************************************/
/* FUNCTION NAME: SendAck                                                                    */
/* DESCRIPTION  : Envoyer un acknowledge                                                     */
/*********************************************************************************************/
void SendAck(unsigned short id, unsigned short from)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=2;
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    // from sur 2 octets
    msgTx.data[0]=(unsigned char)from;
    msgTx.data[1]=(unsigned char)(from>>8);

    can2.write(msgTx);
}

void Send2Short(unsigned short id, unsigned short d1, unsigned short d2)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=4;
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    // from sur 2 octets
    msgTx.data[0]=(unsigned char)d1;
    msgTx.data[1]=(unsigned char)(d1>>8);
    msgTx.data[2]=(unsigned char)d2;
    msgTx.data[3]=(unsigned char)(d2>>8);

    can2.write(msgTx);
}

void SendMsgCan(unsigned short id, unsigned char* data, int len)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=len;
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    // from sur 2 octets
    for(int i = 0; i<len; i++)
    {
        msgTx.data[i]=data[i];
    }

    can2.write(msgTx);
}
void SendCharCan(unsigned short id, unsigned char data)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=1;
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    msgTx.data[0]=data;
    
    can2.write(msgTx);
}