#include "all_includes.h"

Timer t;
Timer TimeJack;

CAN can(p30,p29); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN

Serial pc(USBTX, USBRX);

#ifdef AVANT
    void gerer_turbine(unsigned char pwm_turbine);
#endif

unsigned char Cote=0;

#ifdef AVANT 
    PwmOut Pompe(p21);
    PwmOut ElectroVanne(p22);
    PwmOut turbine(p23);
    
#endif

#ifdef ARRIERE
    PwmOut Pompe(p21);
    PwmOut MotLanceur(p22);
    InterruptIn jack(p23);
    //DigitalIn Jack(p25);
#endif 



AnalogIn telemetre(p15);




DigitalOut led(LED1);
DigitalOut led2(LED2);

unsigned char EtatPompe=0, EtatLanceur=0, EtatAx12=0, ChoixBras=0, ActionAx12=0, EtatTurbine=0, EtatElectroVanne=0, EtatFunnyAction=0, EtatGameEnd=0, EnvoieJack=0;
unsigned char action_a_effectuer=0, ActionPompe=0, EtatCarteAvant=0, EtatCarteArriere=0;


/*
DigitalIn IO1(p23);
DigitalIn IO2(p24);
DigitalIn IO3(p25);
DigitalIn IO4(p26);

AnalogIn A_in1(p15);
AnalogIn A_in2(p16);
AnalogIn A_in3(p17);
AnalogIn A_in4(p18);
AnalogIn A_in5(p19);
AnalogIn A_in6(p20);

PwmOut IRL_1(p21);
PwmOut IRL_2(p22);
*/

/****************************************************************************************/
/* FUNCTION NAME: jack_ISR                                                              */
/* DESCRIPTION  : Interruption en changement d'état sur le Jack                         */
/****************************************************************************************/
#ifdef ARRIERE
void jack_ISR (void)
{
    led2=1;
    SendRawId(GLOBAL_JACK);
    EnvoieJack = 1;
    TimeJack.start();
}
#endif


    
int main() {
    
    can.frequency(1000000); // fréquence de travail 1Mbit/s
    can.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
 
    // message CAN autorise a declencher l'interruption
    
    CAN2_wrFilter(POMPE);
    
    CAN2_wrFilter(LANCEUR);
    CAN2_wrFilter(TURBINE);
    CAN2_wrFilter(ELECTROVANNE);
    CAN2_wrFilter(0x123);
     
    CAN2_wrFilter(CHECK_CARTE_AVANT);
    CAN2_wrFilter(CHECK_CARTE_ARRIERE); 
    CAN2_wrFilter(ACKNOWLEDGE_GLOBAL_JACK);
       
    CAN2_wrFilter(SERVO_AX12_ACTION);
    CAN2_wrFilter(SERVO_AX12_ACK);
    CAN2_wrFilter(SERVO_AX12_END);
    CAN2_wrFilter(CHECK_AX12);
    CAN2_wrFilter(GLOBAL_FUNNY_ACTION);
    CAN2_wrFilter(GLOBAL_GAME_END);
    
    
    
    
    #ifdef AVANT 
        Pompe.period(0.00005);
        ElectroVanne.period(0.00005);
        turbine.period(0.00005);
    #endif

    
    #ifdef ARRIERE
        Pompe.period(0.00005); 
        MotLanceur.period(0.00005);
    #endif
   
    
 
    
    
    while(1) {
        led = !led;
        canProcessRx();//Traitement des trames CAN en attente 
        
        if (EtatGameEnd==1) {
            #ifdef AVANT 
                Pompe.write(0);
                ElectroVanne.write(0);
                gerer_turbine(0);
            #endif
        
            #ifdef ARRIERE
                Pompe.write(0); 
                MotLanceur.write(0);
            #endif  
         
        }
        
        if ((EnvoieJack==1)  && (TimeJack.read_ms()>100)){
            SendRawId(GLOBAL_JACK); 
            TimeJack.reset();    
        }
        
           
             
        
        
        if (action_a_effectuer==1) {
            action_a_effectuer=0;
            
            if (Cote==CARTE) {
                #ifdef AVANT
                    if (EtatCarteAvant==1) {
                        EtatCarteAvant=0;
                        initialisation_AX12();
                        
                        AX12_automate(1);
                        AX12_automate(16);
                        AX12_automate(21);    
                    }
                #endif
                
                #ifdef ARRIERE
                    if (EtatCarteArriere==1) {
                        EtatCarteArriere=0;
                        
                        initialisation_AX12();
                        AX12_automate(1);
                        AX12_automate(36);
                        AX12_automate(41);
                        jack.mode(PullDown); // désactivation de la résistance interne du jack
                        jack.fall(&jack_ISR); // création de l'interrupt attachée au changement d'état (front descendant) sur le jack   
                    }
                #endif
                
                if (EtatFunnyAction==1){
                    AX12_automate(22); //Funny Action
                }
                
                
                if (ActionAx12==1){
                    AX12_automate(EtatAx12);
                    ActionAx12=0;
                }
                
                if ((EtatPompe==1)&&(ActionPompe==1))
                    ActionPompe=0, Pompe.write(1); 
                else if ((EtatPompe==0)&&(ActionPompe==1))
                    Pompe.write(0), ActionPompe=0;
                
                #ifdef AVANT
                    if (EtatTurbine==1)
                        turbine.write(1);
                    else if (EtatTurbine==0)
                         turbine.write(0);
                                   
                    if (EtatElectroVanne==1)
                        ElectroVanne.write(1);
                    else if (EtatElectroVanne==0)
                        ElectroVanne.write(0); 
                #endif
                
                #ifdef ARRIERE   
                    if (EtatLanceur==1) {
                        MotLanceur.write(1);
                        wait(0.2);
                        
                        unsigned char i;
                        for(unsigned char j=1;j<10;j++) {
                            for(i=10;i>5;i--) {
                                float value=(float)i/10.;
                                MotLanceur.write(value);
                                wait(0.2);
                            }
                        }
                        MotLanceur.write(0);
                        
                        /*   MotLanceur.write(1);
                        wait(0.2);
                        MotLanceur.write(0.27);
                        wait(0.1);
                        MotLanceur.write(1);
                        wait(0.1);
                        MotLanceur.write(0.27);
                        wait(0.1);
                        MotLanceur.write(1);
                        wait(0.1);
                        MotLanceur.write(0.27);
                        wait(0.1);
                        MotLanceur.write(1);
                        wait(0.1);
                        MotLanceur.write(0.27);
                        wait(3);
                        MotLanceur.write(0);*/
                    }
                    else if (EtatLanceur==0)
                        MotLanceur.write(0); 
                #endif
                
            }
        }    
    }
}






