#include "mbed.h"
#include <stdio.h>

//les 4 premiers bits de la variable trame sont pour la couleur
#define bleu    0x1000
#define rouge   0x2000
#define violet  0x4000 //bleu et rouge
#define rose    0x8000
//les 4 suivants pour le nombre de capteurs recus
//les 12 suivants toutes les positions des robots
#define nord    0x0100
#define est     0x0200
#define ouest   0x0400
#define sud     0x0800
//les directions des robots advers
#define face      0x0010
#define droite    0x0020
#define gauche    0x0040
#define derriere  0x0080

Serial pc(SERIAL_TX, SERIAL_RX, 115200);

DigitalIn IT(PA_3);

Ticker ticker;
DigitalOut tick(PA_8);

SPI spi(PA_7, PA_6, PA_5);  //mosi, miso, sclk
DigitalOut cs(PA_4);        //lance le compteur du SPI sur le FPGA

//cette fonction permet de generer un tick au FPGA pour changer le numero du capteur et aussi cadencé appel_spi()
void flip();

//permet de parler en SPI avec le FPGA
int appel_spi();

//calculer le nombre de capteur + le type du robot
void mini_traitement(unsigned int tableau[]);

//pour le SPI
int trame_spi = 0, pause_entre_trame = 0, ctp_ticker = 0, incrementation_for = 0;
//pour le traitement
int trame = 0, trame_robot1 = 0, trame_robot2 = 0, trame_robot3 = 0, urgence = 0;


int main()
{
    cs = 1;
    spi.format(16,0);
    spi.frequency(1000000);         //1MHz soit 1µs de periode par bits dans la trame si
    ticker.attach(&flip, 0.0005);   //soit 1ms entre chaque trame
    unsigned int tableau[20] = {0};

    while(1) {

        //partie SPI
        if(IT == 1) {
            for(incrementation_for = 0; incrementation_for < 17; incrementation_for++) {
                //je lis tout les capteurs soit 16 fois, +1 fois (cours de S3) car le premier appel en SPI n'est pas correct
                appel_spi();
                tableau[incrementation_for] = trame_spi;
                //normalement si on printf l'ordre des trames est 0/8/4/C/2/A/6/E/1/9/5/D/3/B/7/F soit les numeros des capteurs
                //pc.printf("%X\n\n\r",trame_spi);
            }
            //on fait une pause de 18 tick avant de redemander les 16 trames
            if(incrementation_for == 17)    pause_entre_trame = 1;

            mini_traitement(tableau);
            trame = 0;
        }
    }
}

void flip()
{
    if(pause_entre_trame == 0) tick = !tick;
    if(pause_entre_trame == 1) {
        ctp_ticker++;
        if(ctp_ticker == 18) {
            pause_entre_trame = 0;
            ctp_ticker = 0;
        }
    }
}

int appel_spi()
{
    if(incrementation_for == 16) {
        cs = 0;
        trame_spi = spi.write(0x5555);
        cs = 1;
    } else {
        while(tick == 1);
        cs = 0;
        trame_spi = spi.write(0x5555);
        wait_ms(0.05);
        cs = 1;
        while(tick == 0);
    }
    return trame_spi;
}

void mini_traitement(unsigned int tableau[])
{
    char a = 0, b = 0, c = 0, d = 0, e = 0, f = 0, g = 0, h = 0, j = 0, k = 0, l = 0, m = 0;
    int traitement_type = 0;
    int nb_robot = 0, nb_capteur = 0, type_robot = 0, type_robot_1 = 0, type_robot_2 = 0, type_robot_3 = 0, cote = 0, cote_robot_1 = 0, cote_robot_2 = 0, cote_robot_3 = 0;
    unsigned char tab[4][20];
    for(char i = 0; i < 4; i++) {
        for(char n = 0; n < 20; n++) tab[i][n] = 0;
    }
    int cote_robot[4];
    for(char i = 0; i < 4; i++) cote_robot[i] = 0;

    for(char i = 1; i < 17; i++) {
        if((tableau[i] & 0xFFF0) != 0) {
            nb_capteur ++;
            traitement_type = (tableau[i] & 0x1800);
            if(i == 5 || i == 6 || (i >= 8 && i <= 12)) {
                if       (traitement_type == 0x1000) {b++;tab[2][i] = 1;
                } else if(traitement_type == 0x0800) {a++;tab[1][i] = 1;
                } else if(traitement_type == 0x1800 || traitement_type == 0x0000) {c++;tab[3][i] = 1;}
            } else {
                if       (traitement_type == 0x1000) {a++;tab[1][i] = 1;
                } else if(traitement_type == 0x0800) {b++;tab[2][i] = 1;
                } else if(traitement_type == 0x1800 || traitement_type == 0x0000) {c++;tab[3][i] = 1;}
            }
        }
    }

    //nombre de robot + type de robot + nb capteur
    //methode 2 de spi_traitement_v1
    if(a >= 1) { nb_robot++; type_robot = bleu; type_robot_1 = bleu; }
    if(b >= 1) { if(nb_robot == 1) type_robot = violet; else type_robot = rouge; nb_robot++; type_robot_2 = rouge; }
    if(c >= 1) { if(nb_robot == 2) type_robot = type_robot | rose; else if(nb_robot == 1) type_robot = type_robot | rose; else type_robot = rose; nb_robot++; type_robot_3 = rose; }
    trame_robot1 = type_robot_1 | a;
    trame_robot2 = type_robot_2 | b;
    trame_robot3 = type_robot_3 | c;
    d = a + b + c;
    trame = type_robot | (d << 4) | nb_robot;

    //cote par rapport a notre robot
    for(char i = 1; i < 4; i++) {   

        if((tab[i][16] == 1 || tab[i][15] == 1 || tab[i][1] == 1) && e == 0) {
            e = 1;
            cote = est;
            if(tab[i][3] == 1) cote = cote | nord;
            if(tab[i][13] == 1) cote = cote | sud;
        } else if((tab[i][4] == 1 || tab[i][3] == 1 || tab[i][5] == 1) && f == 0) {
            f = 1;
            cote = nord;
            if(tab[i][1] == 1) cote = cote | est;
            if(tab[i][7] == 1) cote = cote | ouest;
        } else if((tab[i][8] == 1 || tab[i][7] == 1 || tab[i][9] == 1) && g == 0) {
            g = 1;
            cote = ouest;
            if(tab[i][5] == 1) cote = cote | nord;
            if(tab[i][11] == 1) cote = cote | sud;
        } else if((tab[i][12] == 1 || tab[i][11] == 1 || tab[i][13] == 1) && h == 0) {
            h = 1;
            cote = sud;
            if(tab[i][9] == 1) cote = cote | ouest;
            if(tab[i][15] == 1) cote = cote | est;
        } else {
            if(tab[i][2] == 1 && j == 0) {
                j = 1;
                cote = est | nord;
            } else if(tab[i][6] == 1 && k == 0) {
                k = 1;
                cote = nord | ouest;
            } else if(tab[i][10] == 1 && l == 0) {
                l = 1;
                cote = ouest | sud;
            } else if(tab[i][14] == 1 && m == 0) {
                m = 1;
                cote = sud | est;
            }
        }
        if(i == 1) cote_robot_1 = cote;
        if(i == 2) cote_robot_2 = cote;
        if(i == 3) cote_robot_3 = cote;
        cote = 0;
        
        //cote robot advers
        for(char o = 1; o < 17; o++) {
            if(tab[i][o] == 1) {
                cote_robot[i] = (tableau[i] & 0x0700);
                if     (cote_robot[i] == 0x0000) cote_robot[i] = face;                 //pc.printf("face\n\n\r"); }
                else if(cote_robot[i] == 0x0100) cote_robot[i] = derriere;             //pc.printf("derriere\n\n\r"); }
                else if(cote_robot[i] == 0x0200) cote_robot[i] = droite;               //pc.printf("droite\n\n\r"); }
                else if(cote_robot[i] == 0x0300) cote_robot[i] = gauche;               //pc.printf("gauche\n\n\r"); }
                else if(cote_robot[i] == 0x0400) cote_robot[i] = face | droite;        //pc.printf("face droite\n\n\r"); }
                else if(cote_robot[i] == 0x0500) cote_robot[i] = face | gauche;        //pc.printf("face gauche\n\n\r"); }
                else if(cote_robot[i] == 0x0600) cote_robot[i] = derriere | droite;    //pc.printf("derriere droite\n\n\r"); }
                else                             cote_robot[i] = derriere | gauche;    //pc.printf("derriere gauche\n\n\r"); }
            }
        }
    }
    trame_robot1 = trame_robot1 | cote_robot_1 | cote_robot[1];
    trame_robot2 = trame_robot2 | cote_robot_2 | cote_robot[2];
    trame_robot3 = trame_robot3 | cote_robot_3 | cote_robot[3];
    trame = trame | cote_robot_1 | cote_robot_2 | cote_robot_3;


    pc.printf("%X ; %X ; %X ; %X\n\n\r", trame, trame_robot1, trame_robot2, trame_robot3);
}
