#include "mbed.h"

#define SIZE_FIFO 20

/*
DigitalIn IO1(p23);
DigitalIn IO2(p24);
DigitalIn IO3(p25);
DigitalIn IO4(p26);

AnalogIn A_in1(p15);
AnalogIn A_in2(p16);
AnalogIn A_in3(p17);
AnalogIn A_in4(p18);
AnalogIn A_in5(p19);
AnalogIn A_in6(p20);

PwmOut IRL_1(p21);
PwmOut IRL_2(p22);
*/

AnalogIn cptGauche(p20);
AnalogIn cptDroit(p19);

DigitalIn pressionGauche(p23);
DigitalIn pressionDroit(p24);

PwmOut moteurGauche(p21);
PwmOut moteurDroit(p22);

AnalogIn telemetre(p15);

DigitalIn jack(p25);



DigitalOut led(LED1);

CAN can1(p30,p29); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN

signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN
int printCapteurs = 0;

void canRx_ISR (void)
{
    if (can1.read(msgRxBuffer[FIFO_ecriture])) {
        /*if(msgRxBuffer[FIFO_ecriture].id==RESET_ACTIONNEURS) mbed_reset();
        else FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;*/
        FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
    }
}



/*********************************************************************************************************/
/* FUNCTION NAME: SendRawId                                                                              */
/* DESCRIPTION  : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendRawId (unsigned short id)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=0;
    can1.write(msgTx);
    wait_us(200);
}

/****************************************************************************************/
/* FUNCTION NAME: canProcessRx                                                          */
/* DESCRIPTION  : Fonction de traitement des messages CAN                               */
/****************************************************************************************/
void canProcessRx(void){
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;
    CANMessage msgTx=CANMessage();
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
    if(FIFO_occupation!=0) {
        
        switch(msgRxBuffer[FIFO_lecture].id) {
            case 0x63:
                SendRawId(0x73);
            break;
            case 0x10:
                printCapteurs = 0;
                break;
            case 0x11:
                printCapteurs = 1;
                break;
                
            
        }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
}
    
int main() {
    can1.frequency(1000000); // fréquence de travail 1Mbit/s
    can1.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    
    CANMessage msgTx=CANMessage();

    while(1) {
        led = !led;

        canProcessRx();
        if (printCapteurs){
            msgTx.id=0x21;
            msgTx.format=CANStandard;
            msgTx.type=CANData;
            msgTx.len=7;
            
            msgTx.data[0]=(unsigned char)cptGauche.read();
            msgTx.data[1]=(unsigned char)cptDroit.read();
            msgTx.data[2]=(unsigned char)pressionGauche.read();
            msgTx.data[3]=(unsigned char)pressionDroit.read();
            msgTx.data[4]=(unsigned char)jack.read();
            msgTx.data[5]=(unsigned char)(telemetre.read_u16()>>8);
            msgTx.data[6]=(unsigned char)telemetre.read_u16();
                           
            can1.write(msgTx);
            
        }
        wait(0.5); 
    }
}

