#include "lib_cap.h"
#include "mbed.h"

//     définie le capteur
CAP::CAP(PinName in_A, int mode): _cap(in_A){
    _mode = mode;
}
    
//**********************************************
//     choisir le mode et la donnée renvoie
//**********************************************
int CAP::valeur(){
    switch (_mode){
        case COULEUR:
            return color();  // renvoi '1' ou '0'
            
        case OBJET:
            return objet();  // renvoi '1' ou '0'
            
        case DISTANCE:
            return distance();  // renvoi '0' - '3000'
        }
}
/**************************************************
Exemple:
#include "mbed.h"
#include "lib_cap.h"

CAP col(PA_1,COULEUR);
CAP obj(PA_7,OBJET);
CAP dis(PA_4,DISTANCE);
Serial pc(SERIAL_TX, SERIAL_RX);
DigitalOut myled(LED1);


int main(){
    while(1){
        if (col.valeur() != 1){
            myled = 1;
            pc.printf("detecter\n");
        }
        else{
            myled = 0;
             pc.printf("non detecteur\n");
        }
        if (obj.valeur() != 1){
            pc.printf("hi\n");
        }
        else{
            pc.printf("au revoir\n");
        }
        pc.printf("distance: %d  \n", dis.valeur());
    }
}
**************************************************/    








//**********************************************
//   donnée retournée de cap_couleur
//      '1' Non détecter     
//      '0' détecter le bon coleur   
//**********************************************
int CAP::color(){
    unsigned short in_valeur = _cap.read_u16();
    int cap_color;  
        if (cap_color != 1){
            if ( in_valeur > 0xc9b1 ) cap_color = 1;
        }
        else{
            if ( in_valeur < 0x41f0 ) cap_color = 0;
        }  
    return cap_color;
}







//**********************************************
//   donnée retournée de cap_objet
//      '1' Non détecter     
//      '0' détecter l'bojet 
//**********************************************     
int CAP::objet(){
    unsigned short in_valeur = _cap.read_u16();
    int cap_objet;  
        if (cap_objet != 1){
            if ( in_valeur > 0xc9b1 ) cap_objet = 1;
        }
        else{
            if ( in_valeur < 0x41f0 ) cap_objet = 0;
        }  
    return cap_objet;
}







//***********************************************
//      donnée retournée de cap_distance
//          definie par 'mm'
//         range de détection 0 - 3m
//***********************************************
int CAP::distance(){
    unsigned short in_valeur = _cap.read_u16();
    double cap_distance;
    unsigned int l_min = 0x26c9;
    //  quand la distance est 0, le valeur de la sortie 0x26c9  (9929)
    //  quand la distance est 3000mm, le valeur de la sortie 0xffff (65535)
    double d = 0.0558;
    //  d répresente la distance de 0x0001
    
    cap_distance = ((double)in_valeur - (double)l_min) * d;
    
    return (int)cap_distance;
}  
    
    
    
    
    