#include "mbed.h"

#define COULEUR 0
#define OBJET 1
#define DISTANCE 2


class CAP {
      
public:
    
    CAP(PinName in_A, int mode);
    /**  @param PIN data A_IN
    *    @param mode:
    *                   '0' détecteur de couleur
    *                   '1' détecteur d'objet
    *                   '2' détecteur de la distance
    */
    

    int valeur();
    /**
    *    @param mode:
    *                   '0' color();
    *                   '1' objet();
    *                   '2' distance();
    */
    
    int color();
    /**  fonction permet de détecter des couleurs
    *       '1' on a détecté un bon couleur
    *       '0' on n'a pas détecté un bon couleur
    */
        
    int objet();   
    /**  fonction permet de détecter des objets
    *       '1' on a détecté un objet
    *       '0' on n'a pas détecté un objet
    */
        
    int distance();
    /**  fonction permet de détecter la distance
    *    valeur renvoi définé en mm
    */

    
    private :
        AnalogIn _cap;
        int _mode;
};
    