#include "lib_cap.h"
#include "mbed.h"

//     définie le capteur
CAP::CAP(PinName in_A, int mode): _cap(in_A){
    _mode = mode;
}
    
//**********************************************
//     choisir le mode et la donnée renvoie
//**********************************************
int CAP::valeur(){
    switch (_mode){
        case COULEUR:
            return color();  // renvoi '1' ou '0'
            
        case OBJET:
            return objet();  // renvoi '1' ou '0'
            
        case DISTANCE:
            return distance();  // renvoi '0' - '3000'
        }
}

//**********************************************
//   donnée retournée de cap_couleur
//      '1' Non détecter     
//      '0' détecter le bon coleur   
//**********************************************
int CAP::color(){
    unsigned short in_valeur = _cap.read_u16();
    int cap_color;  
        if (cap_color != 1){
            if ( in_valeur > 0xe8b9 ) cap_color = 1;
        }
        else{
            if ( in_valeur < 0x41f0 ) cap_color = 0;
        }  
    return cap_color;
}

//**********************************************
//   donnée retournée de cap_objet
//      '1' Non détecter     
//      '0' détecter l'bojet 
//**********************************************     
int CAP::objet(){
    unsigned short in_valeur = _cap.read_u16();
    int cap_objet;  
        if (cap_objet != 1){
            if ( in_valeur > 0xe8b9 ) cap_objet = 1;
        }
        else{
            if ( in_valeur < 0x41f0 ) cap_objet = 0;
        }  
    return cap_objet;
}


//***********************************************
//      donnée retournée de cap_distance
//          definie par 'mm'
//         range de détection 0 - 3m
//***********************************************
int CAP::distance(){
    unsigned short in_valeur = _cap.read_u16();
    double cap_distance;
    unsigned int l_min = 0x2ded;
    //  quand la distance est 0, le valeur de la sortie 0x2ded  (11757)
    //  quand la distance est 3000mm, le valeur de la sortie 0xffff (65535)
    double d = 0.0558;
    //  d répresente la distance de 0x0001
    
    cap_distance = ((double)in_valeur - (double)l_min) * d;
    
    return (int)cap_distance;
}  
    
    
    
    
    