#ifndef LIAISON_BLUETOOTH_PANNEAU_GROSROB
#define LIAISON_BLUETOOTH_PANNEAU_GROSROB

#define MARQUEUR_DEBUT_TRAME '\x02'
#define MARQUEUR_FIN_TRAME '\x04'

#define PAQUET_IDENTIFIANT_RAFRAICHIRSCORE 0x30 //utilisé par le gros robot vers panneau domotique
#define PAQUET_IDENTIFIANT_FINMATCH 0x31 //utilisé par le gros robot vers panneau domotique
#define PAQUET_IDENTIFIANT_AJOUTERSCORE 0x32 //utilisé par le petit robot vers gros robot

#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "mbed.h"

typedef struct {
    int identifiant;
    unsigned int longueur;
    char *data;
} PaquetDomotique;

class LiaisonBluetooth
{
private:
    Serial *m_bluetooth, *m_pc;
    bool m_state;

public:
    LiaisonBluetooth(Serial *bluetooth, Serial *pc);

    bool paquet_en_attente();
    PaquetDomotique *lire();
    
    void envoyer(char idenfitiant, int longueur_data, char *data);
    void envoyer_short(char indentifiant, short data);
};

PaquetDomotique *creer_paquetdomotique(int identifiant, unsigned int longueur_data, char *data);
void detruire_paquetdomotique(PaquetDomotique *paquet);

short convertir_score(PaquetDomotique *paquet);

#endif
