#include "global.h"

/*
if (action_robot_2) {
    char *score_char_array = convertir_int_en_4char(score_total);
    paquet_domotique_envoyer(0x30, 4, score_char_array);
    delete []score_char_array;
}
*/

LiaisonBluetooth::LiaisonBluetooth(Serial *bluetooth, Serial *pc) : m_bluetooth(bluetooth), m_pc(pc), m_state(true)
{
}

bool LiaisonBluetooth::paquet_en_attente()
{
    char c;
    while (m_bluetooth->readable() && m_state) {
        c = m_bluetooth->getc();
        if (c == MARQUEUR_DEBUT_TRAME) {
            return true;
        }
    }

    return false;
}

PaquetDomotique *LiaisonBluetooth::lire()
{
    char identifiant = 0;
    
    wait_ms(10);
    
    if (m_bluetooth->readable() && m_state) {
        identifiant = m_bluetooth->getc();
    } else { m_pc->printf("error identifiant %d\n", identifiant); return NULL; }

    char buffer_longueur_paquet[4];
    for (int i = 0 ; i < 4 ; i++) {
        if (m_bluetooth->readable() && m_state) {
            buffer_longueur_paquet[i] = m_bluetooth->getc();
        } else { m_pc->printf("error buffer_longueur_paquet %d\n", i); return NULL; }
    }
    unsigned short longueur_paquet = atoi(buffer_longueur_paquet);
    
    //m_pc->printf("longueur %d\n", longueur_paquet);
    
    wait_ms(10);
    
    char buffer_data[longueur_paquet];
    int index = 0;
    while (index < longueur_paquet) {
        if (m_bluetooth->readable() && m_state) {
            char c = m_bluetooth->getc();
            
            //m_pc->printf("%x\n", c);
            
            if (c == MARQUEUR_FIN_TRAME) {
                m_pc->printf("error MARQUEUR_FIN_TRAME %d\n", index);
                return NULL;
            }

            buffer_data[index++] = c;
        } else { m_pc->printf("buffer_data\n"); return NULL; }
    }
    
    
    return creer_paquetdomotique(identifiant, longueur_paquet, buffer_data);
}

void LiaisonBluetooth::envoyer(char idenfitiant, int longueur_data, char *data)
{
    m_bluetooth->putc(MARQUEUR_DEBUT_TRAME);
    m_bluetooth->putc(idenfitiant);

    //char *longueur_buffer = convertir_int_en_4char(longueur_data);
    char str[4]={0,0,0,0}; 
    sprintf(str,"%d", longueur_data);
    for (int i = 0 ; i < 4 ; i++) {
        m_bluetooth->putc(str[i]);
    }

    for (int i = 0 ; i < longueur_data ; i++) {
        m_bluetooth->putc(data[i]);
    }
    
    m_bluetooth->putc(MARQUEUR_FIN_TRAME);
}

void LiaisonBluetooth::envoyer_short(char identifiant, short data) {
    char buffer[7];
    memset(buffer, '\0', 7);
    sprintf(buffer, "%hd", data);
    envoyer(identifiant, 7, buffer);
}

PaquetDomotique *creer_paquetdomotique(int identifiant, unsigned int longueur_data, char *data)
{
    PaquetDomotique *paquet = (PaquetDomotique*)malloc(sizeof(PaquetDomotique));
    paquet->identifiant = identifiant;

    paquet->data = (char*)malloc(sizeof(char)*longueur_data);
    memset(paquet->data, 0, longueur_data);
    strcpy(paquet->data, data);
    
    paquet->longueur = longueur_data;

    return paquet;
}
void detruire_paquetdomotique(PaquetDomotique *paquet)
{
    free(paquet->data);
    free(paquet);
}

short convertir_score(PaquetDomotique *paquet) {
    char buff[20];
    memset(buff, '\0', 20);
    strncpy(buff, paquet->data, paquet->longueur);
    return atoi(buff);
}
