
                                 
                    /*       PROTOTYPES DE FONCTIONS ET POINTEURS       */
                    
void declarationAX12(void);

/****************************************************************************************/
/* FUNCTION NAME: Initialisation_position                                               */
/* DESCRIPTION  : Fonction qui place les bras en position verticale                     */
/****************************************************************************************/
void Initialisation_position(void);

/****************************************************************************************/
/* FUNCTION NAME: Preparation_prise                                                     */
/* DESCRIPTION  : Fonction qui prepare le robot pour prendre les modules                */
/****************************************************************************************/
void Preparation_prise(void);

/****************************************************************************************/
/* FUNCTION NAME: Stockage_haut                                                         */
/* DESCRIPTION  : Fonction qui prend et stocke les modules dans la position haute       */
/****************************************************************************************/
void Stockage_haut(void);

/****************************************************************************************/
/* FUNCTION NAME: Stockage_bas                                                          */
/* DESCRIPTION  : Fonction qui prend et stocke un module dans la pince                  */
/****************************************************************************************/
void Stockage_bas(void);

/****************************************************************************************/
/* FUNCTION NAME: Deposer                                                               */
/* DESCRIPTION  : Fonction qui permet de déposer un module                              */
/****************************************************************************************/
void Deposer(void);

/****************************************************************************************/
/* FUNCTION NAME: Preparation_depos_bas                                                 */
/* DESCRIPTION  : Fonction qui prépare le depos d'un module en bas                      */
/****************************************************************************************/
void Preparation_depot_bas(void);

/****************************************************************************************/
/* FUNCTION NAME: Preparation_depos_haut                                                */
/* DESCRIPTION  : Fonction qui prépare le depos d'un module en haut                     */
/****************************************************************************************/
void Preparation_depot_haut(void);

/****************************************************************************************/
/* FUNCTION NAME: Pousser_module                                                        */
/* DESCRIPTION  : Fonction qui permet pousser le module situé à l'entrée de la bas      */
/****************************************************************************************/
void Pousser_module(void);

/****************************************************************************************/
/* FUNCTION NAME: Initialisation_gauche                                                 */
/* DESCRIPTION  : Fonction qui permet de placer le cote gauche en position initiale     */
/****************************************************************************************/
void Initialisation_gauche(void);
    
/****************************************************************************************/
/* FUNCTION NAME: Preparation_prise_gauche                                              */
/* DESCRIPTION  : Fonction qui permet prendre un module sur le cote gauche              */
/****************************************************************************************/
void Preparation_prise_gauche(void);

/****************************************************************************************/
/* FUNCTION NAME: Prendre_module_gauche                                                 */
/* DESCRIPTION  : Fonction qui permet prendre un module sur le cote gauche              */
/****************************************************************************************/
void Prendre_module_gauche(void);

/****************************************************************************************/
/* FUNCTION NAME: Tourner_module_gauche                                                 */
/* DESCRIPTION  : Fonction qui permet de tourner les modules a gauche                   */
/****************************************************************************************/
void Tourner_module_gauche(void);

/****************************************************************************************/
/* FUNCTION NAME: Preparatio_module_gauche                                              */
/* DESCRIPTION  : Fonction qui prepare le tournante                                     */
/****************************************************************************************/
void Preparation_module_gauche(void);

void getPosiotionCentrale(void);
void getPosiotionGauche(void);
void getPosiotionDroite(void);
