#ifndef GLOBAL_H
#define GLOBAL_H

#include "mbed.h"

#include "ident_crac.h"
#include "constantes.h"

#include <CAN.h>
#include <DirHandle.h>
#include "SDFileSystem.h"
#include "conv_data.h"
#include "LiaisonBluetooth.h"
#include "Instruction.h"
#include "Strategie.h"
#include "lecture_repertoire.h"
#include "SerialHalfDuplex.h"
#include "debug.h"
#include "Asservissement.h"
#include "TS_DISCO_F469NI.h"
#include "LCD_DISCO_F469NI.h"
#include "fonts.h"
#include "F469_GUI.hpp"
#include "Evitement.h"
#include "ihm.h"
#include "Compteur.h"
#include "bon_port.h"
extern unsigned char ingnorInversionOnce;
extern signed char asser_stop_direction;
extern E_InstructionType actionPrecedente;
extern Serial pc;
//extern E_stratGameEtat gameEtat = ETAT_CHECK_CARTES;
//extern T_etat strat_etat_s = INIT;
extern CAN can1;
extern CAN can2;
extern CANMessage msgRxBuffer[SIZE_FIFO];
extern unsigned char FIFO_ecriture;
extern char strat_sd[10][SIZE+8];
extern char PATH[10][SIZE+8];
extern signed short x_robot;
extern signed short y_robot;
extern signed short theta_robot;
extern signed char nbStrat;
extern unsigned short flag_check_carte;
extern int ack_bluetooth;
extern unsigned char Cote;
extern unsigned char Hauteur;
extern DigitalOut led1,led2,led3,led4;
extern LCD_DISCO_F469NI lcd;
extern char cheminFileStart[SIZE+8]; //Le chemin du fichier de strat, utiliser strcpy(cheminFileStart,"/local/strat.txt");
extern short SCORE_GLOBAL;
extern short SCORE_PR, SCORE_GR;
extern Serial rn42_Tx;
extern Serial rn42_Rx;
extern Serial rn42_pr;
extern LiaisonBluetooth liaison_Tx;
extern LiaisonBluetooth liaison_Rx;
extern LiaisonBluetooth liaison_pr;
extern struct S_Instruction strat_instructions[SIZE_BUFFER_FILE]; //La liste des instruction chargé en mémoire
extern unsigned char nb_instructions; //Le nombre d'instruction dans le fichier de strategie
extern unsigned char actual_instruction;//La ligne de l'instruction en cours d'execution

extern unsigned short telemetreDistance;
extern char couleur1, couleur2, couleur3;
extern unsigned char InversStrat;//Si à 1, indique que l'on part de l'autre cote de la table(inversion des Y)

extern unsigned short waitingAckID;//L'id du ack attendu
extern unsigned short waitingAckFrom;//La provenance du ack attendu
extern char modeTelemetre; // Si à 1, indique que l'on attend une reponse du telemetre 
extern unsigned short waitingId;

extern unsigned char isStopEnable;

extern char sd_present;
extern char can_present;
#endif
