#include "global.h"

#define M_PI 3.14159265358979323846
#define DEMI_GOBELET 30

int Ventouse_coord[6][2]={{145,-75},{145,0},{145,75},{-145,75},{-145,0},{-145,-75}};
int Bras_coord[6][2];
int Manche_air_coord[6][2];

int score_final=0;
int score_ventouse=0,gobelet_vert=0,gobelet_rouge=0,gobelet_port=0;
int score_manche=0,manche_releve=0;
int score_bon_port=0;
int score_phare=0;
int score_pavillon=0;

int etat_groupe, gobelet_en_place=0, old_gobelet=0;
unsigned char num_groupe;

CompteurGameEtat VentEtat[6] = {ETAT_ATTENDRE, ETAT_ATTENDRE, ETAT_ATTENDRE, ETAT_ATTENDRE, ETAT_ATTENDRE, ETAT_ATTENDRE};
int deja_compter[6] = {0, 0, 0, 0, 0, 0};

/********************************************************************************************************************/
/* FUNCTION NAME: gestion_Message_CAN                                                                               */
/* DESCRIPTION  : Récupère message CAN et appelle la fonction correspondante à l'action rapportant des points       */
/********************************************************************************************************************/
void gestion_Message_CAN(void)
{
    int identifiant = msgRxBuffer[FIFO_ecriture].id;
    
    switch(identifiant)
    {
        case 0x220:
            for(int num_vent=0;num_vent<6;num_vent++)
            {        
                switch(VentEtat[num_vent])
                {
                    case ETAT_ATTENDRE:
                    etat_groupe = msgRxBuffer[FIFO_ecriture].data[num_vent];
                    if(etat_groupe == 5) //Pompe et capteur
                    {
                        VentEtat[num_vent] = ETAT_RECUP;
                    }
                    break;
                    
                    case ETAT_RECUP:
                    etat_groupe = msgRxBuffer[FIFO_ecriture].data[num_vent];
                    if(etat_groupe == 2) //Electrovane
                    {
                        VentEtat[num_vent] = ETAT_COMPTER;
                    }
                    break;
                    
                    case ETAT_COMPTER:
                        verif_position_ventouse(num_vent);
                        compteur_de_points();
                        VentEtat[num_vent] = ETAT_ATTENDRE;
                    break;
                }
            }   
        break;
                
        case BRAS_RE:
            num_groupe = msgRxBuffer[FIFO_ecriture].data[0];
            verif_position_bras(num_groupe);
            compteur_de_points();
        break;
                
        case AUTOMATE_MANCHE_BAS:
            num_groupe = msgRxBuffer[FIFO_ecriture].data[0];
            verif_position_manche(num_groupe);
            compteur_de_points();
        break;
    } 
}

void compteur_de_points(void)
{
    int paire_ventouse = abs(gobelet_vert - gobelet_rouge);
    
    //Points gobelets
    score_ventouse = (gobelet_vert*2 + gobelet_rouge*2)*2 - (paire_ventouse)*2 + gobelet_port;
    
    //Points manche à air
    if(manche_releve == 1) score_manche = 5;
    else if(manche_releve == 2) score_manche = 15;
    
    //Points phare
    
    //Points pavillons
    
    //Points d'arrivée à bon port
    
    //Points totaux
    score_final = score_ventouse; //+ score_manche + score_phare + score_pavillon + score_bon_port;
}




/********************************************************************************************************************/
/* FUNCTION NAME: verif_position_ventouse                                                                           */
/* DESCRIPTION  : Vérifie si les gobelets posés par les ventouses sont dans un chenal/un port et augmente le score  */
/********************************************************************************************************************/
void verif_position_ventouse(int num_groupe)
{   
    int x_offset = Ventouse_coord[num_groupe][0]*cos(theta_robot*M_PI/1800) - Ventouse_coord[num_groupe][1]*sin(theta_robot*M_PI*1800);
    int y_offset = Ventouse_coord[num_groupe][0]*sin(theta_robot*M_PI/1800) + Ventouse_coord[num_groupe][1]*cos(theta_robot*M_PI*1800);
    
    //chenal vert port départ bleu
    if((x_robot+x_offset <= 530+DEMI_GOBELET)&&(x_robot+x_offset >= 500-DEMI_GOBELET)
        && (y_robot+y_offset <= 400+DEMI_GOBELET)&&(y_robot+y_offset >= 0)) gobelet_vert++;
    //chenal rouge port départ bleu
    else if((x_robot+x_offset <= 1100+DEMI_GOBELET)&&(x_robot+x_offset >= 1070-DEMI_GOBELET)
            && (y_robot+y_offset <= 400+DEMI_GOBELET)&&(y_robot+y_offset >= 0)) gobelet_rouge++;
    //port départ bleu
    else if((x_robot+x_offset > 530+DEMI_GOBELET)&&(x_robot+x_offset < 1070-DEMI_GOBELET)
            && (y_robot+y_offset <= 400+DEMI_GOBELET)&&(y_robot+y_offset >= 0)) gobelet_port++;
            
    //chenal vert port ext bleu  
    else if((x_robot+x_offset >= 1700-DEMI_GOBELET)&&(x_robot+x_offset <= 2000+DEMI_GOBELET)
            && (y_robot+y_offset >= 1650-DEMI_GOBELET)&&(y_robot+y_offset <= 1750+DEMI_GOBELET)) gobelet_vert++;         
    //chenal rouge port ext bleu  
    else if((x_robot+x_offset >= 1700-DEMI_GOBELET)&&(x_robot+x_offset <= 2000+DEMI_GOBELET)
            && (y_robot+y_offset >= 1850-DEMI_GOBELET)&&(y_robot+y_offset <= 1950+DEMI_GOBELET)) gobelet_rouge++;
    //port ext bleu  
    else if((x_robot+x_offset >= 1700-DEMI_GOBELET)&&(x_robot+x_offset <= 2000+DEMI_GOBELET)
            && (y_robot+y_offset > 1750+DEMI_GOBELET)&&(y_robot+y_offset < 1850-DEMI_GOBELET)) gobelet_port++;
            
            
    //chenal vert port départ jaune
    else if((x_robot+x_offset <= 530+DEMI_GOBELET)&&(x_robot+x_offset >= 500-DEMI_GOBELET)
            && (y_robot+y_offset <= 3000+DEMI_GOBELET)&&(y_robot+y_offset >= 2600-DEMI_GOBELET)) gobelet_vert++;
    //chenal rouge port départ jaune
    else if((x_robot+x_offset <= 1100+DEMI_GOBELET)&&(x_robot+x_offset >= 1070-DEMI_GOBELET)
            && (y_robot+y_offset <= 3000+DEMI_GOBELET)&&(y_robot+y_offset >= 2600-DEMI_GOBELET)) gobelet_rouge++;
    //port départ jaune
    else if((x_robot+x_offset > 530+DEMI_GOBELET)&&(x_robot+x_offset < 1070-DEMI_GOBELET)
            && (y_robot+y_offset <= 3000+DEMI_GOBELET)&&(y_robot+y_offset >= 2600-DEMI_GOBELET)) gobelet_port++;
            
    //chenal vert port ext jaune  
    else if((x_robot+x_offset >= 1700-DEMI_GOBELET)&&(x_robot+x_offset <= 2000+DEMI_GOBELET)
            && (y_robot+y_offset >= 1050-DEMI_GOBELET)&&(y_robot+y_offset <= 1150+DEMI_GOBELET)) gobelet_vert++;               
    //chenal rouge port ext jaune  
    else if((x_robot+x_offset >= 1700-DEMI_GOBELET)&&(x_robot+x_offset <= 2000+DEMI_GOBELET)
            && (y_robot+y_offset >= 1250-DEMI_GOBELET)&&(y_robot+y_offset <= 1350+DEMI_GOBELET)) gobelet_rouge++;
    //port ext jaune  
    else if((x_robot+x_offset >= 1700-DEMI_GOBELET)&&(x_robot+x_offset <= 2000+DEMI_GOBELET)
            && (y_robot+y_offset > 1150+DEMI_GOBELET)&&(y_robot+y_offset < 1250-DEMI_GOBELET)) gobelet_port++;
}

void verif_position_bras(int num_groupe)
{   

}

void verif_position_manche(int num_groupe)
{    

}