#include "mbed.h"
#include "global.h"
#include <CAN.h>

CAN can1(PB_8,PB_9); // Rx&Tx pour le CAN
CAN can2(PB_5, PB_13);

void bluetooth_init(void);
DigitalIn choix_robot(PG_12);
CANMessage msgRxBuffer[SIZE_FIFO];
unsigned char FIFO_ecriture;
char strat_sd[10][SIZE+8];
char PATH[10][SIZE+8];

Serial rn42_pr(PG_14, PG_9);
//Serial rn42(PA_1,PA_2);
Serial rn42_Tx(PA_2,NC);
Serial rn42_Rx(NC,PA_1);

Serial pc(USBTX,USBRX);
LiaisonBluetooth liaison_Rx(&rn42_Rx,&pc);
LiaisonBluetooth liaison_Tx(&rn42_Tx,&pc);
LiaisonBluetooth liaison_pr(&rn42_pr,&pc);

char cheminFileStart[SIZE+8]; //Le chemin du fichier de strat, utiliser strcpy(cheminFileStart,"/local/strat.txt");
struct S_Instruction strat_instructions[SIZE_BUFFER_FILE]; //La liste des instruction chargé en mémoire
unsigned char nb_instructions; //Le nombre d'instruction dans le fichier de strategie
unsigned char actual_instruction;//La ligne de l'instruction en cours d'execution



unsigned char InversStrat = 1;//Si à 1, indique que l'on part de l'autre cote de la table(inversion des Y)


unsigned short waitingAckID=0;//L'id du ack attendu
unsigned short waitingAckFrom=0;//La provenance du ack attendu
unsigned short waitingId=0;
char modeTelemetre; // Si à 1, indique que l'on attend une reponse du telemetre

DigitalOut led1(LED1);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led2(LED2);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led3(LED3);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led4(LED4);//Led d'indication de problème, si elle clignote, c'est pas bon

/****************************************************************************************/
/* FUNCTION NAME: canRx_ISR                                                             */
/* DESCRIPTION  : Interruption en réception sur le CAN                                  */
/****************************************************************************************/
void canRx_ISR (void)
{
    if (can2.read(msgRxBuffer[FIFO_ecriture])) {
        //if(msgRxBuffer[FIFO_ecriture].id==RESET_STRAT) mbed_reset();
        /*else*/ FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
        //canProcessRx();
    }
}




/**********************************************************************************/
/* FUNCTION NAME: main                                                            */
/* DESCRIPTION  : Fonction principal du programme                                 */
/**********************************************************************************/
int main() {
    can1.frequency(1000000); // fréquence de travail 1Mbit/s
    can2.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    can2.frequency(1000000);
    lcd.DisplayStringAt(0, 0,(uint8_t *)"Initialisation", LEFT_MODE);
    led1 = 1;
    bluetooth_init();
    //lecture_fichier(); //bloquant si pas de carte SD
    led1 = 0;
    wait_ms(2000);//Attente pour que toutes les cartes se lancent et surtout le CANBlue
    while(true) {
        automate_etat_ihm();
        automate_process();//Boucle dans l'automate principal
        canProcessRx();
    }
}

void bluetooth_init(void){
    rn42_Tx.baud(115200);
    rn42_Rx.baud(115200);
    rn42_pr.baud(115200);
    pc.baud(115200);
    pc.printf("ok1");
    /*while(1){ // sert au paramètrage des module RN42
        while(pc.readable()){
            rn42_Tx.putc(pc.getc());
            
        }
        while(rn42_Rx.readable()){
            pc.putc(rn42_Rx.getc());
        }
    }*/
}
