#include "main.h"

#define SIZE_FIFO 50

CAN can(PB_8,PB_9,1000000); // Rx&Tx pour le CAN

Serial pc(USBTX,USBRX);

CANMessage msgRxBuffer[SIZE_FIFO];
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN
signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN
unsigned short ackFinAction = 0;

void canProcessRx(void);


/*********************************************************************************************/
/* FUNCTION NAME: canRx_ISR                                                                  */
/* DESCRIPTION  : lit les messages sur le can et les stocke dans la FIFO                     */
/*********************************************************************************************/
void canRx_ISR (void)
{
    if (can.read(msgRxBuffer[FIFO_ecriture])) 
    {  
        FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;        
    }
}

int main()
{
    can.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    servo_interrupt_en(); //permettre les interuptions
    wait_ms(200);
    deverouillage_torque();
    pc.printf("\nLAUNCHED\n\r");
    while(1) 
    {                    
        canProcessRx();
        f_mesure();
    }
}

/****************************************************************************************/
/* FUNCTION NAME: canProcessRx                                                          */
/* DESCRIPTION  : Fonction de traitement des messages CAN                               */
/****************************************************************************************/
void canProcessRx(void)
{
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;
    CANMessage msgTx=CANMessage();
    
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;
        
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
        
    if(FIFO_occupation!=0) {
        int identifiant=msgRxBuffer[FIFO_lecture].id;

        switch(identifiant) 
        {         
            case TEST_BRAS_1:
                test_BRAS_1();
                break;
                 
            case TEST_BRAS_2: 
                test_BRAS_2();
                break;
                
            case TEST_BRAS_3: 
                test_BRAS_3();
                break;
                
            case TEST_BRAS_4: 
                test_BRAS_4();
                break;
                
            case TEST_BRAS_5: 
                test_BRAS_5();
                break;
                
            case TEST_TELEMETRE_1:
                short distance1=lecture_telemetre(1);
                unsigned char distance_telemetre_1 = distance1;
                SendMsgCan(TELEMETRE_1_REP, &distance_telemetre_1,1);
                break;
            case TEST_TELEMETRE_2:
                short distance2=lecture_telemetre(2);
                unsigned char distance_telemetre_2 = distance2;
                SendMsgCan(TELEMETRE_2_REP, &distance_telemetre_2,1);
                break;
            case TEST_TELEMETRE_3:
                short distance3=lecture_telemetre(3);
                unsigned char distance_telemetre_3 = distance3;
                SendMsgCan(TELEMETRE_3_REP, &distance_telemetre_3,1);
                break;
            case TEST_TELEMETRE_4:
                short distance4=lecture_telemetre(4);
                unsigned char distance_telemetre_4 = distance4;
                SendMsgCan(TELEMETRE_4_REP, &distance_telemetre_4,1);
                break;
                
            default:
                break;
        }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
}