#include "global.h"

/****************************************************************************************/
/* FUNCTION NAME: automate_process                                                      */
/* DESCRIPTION  : Automate de gestion de la stratégie du robot                          */
/****************************************************************************************/
void automate_process(void);

/****************************************************************************************/
/* FUNCTION NAME: canProcessRx                                                          */
/* DESCRIPTION  : Fonction de traitement des messages CAN                               */
/****************************************************************************************/
void canProcessRx(void);

/*********************************************************************************************************/
/* FUNCTION NAME: SendRawId                                                                              */
/* DESCRIPTION  : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendRawId (unsigned short id);

DigitalOut led(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);
/*DigitalIn IO1(PB_7);
DigitalIn IO2(PB_6);
DigitalIn IO3(PF_1);
DigitalIn IO4(PA_8);

DigitalIn A_in1(PB_7);
DigitalIn A_in2(PA_6);
DigitalIn A_in3(PA_4);
DigitalIn A_in4(PA_1);
DigitalIn A_in5(PA_0); 

DigitalOut AX12(PA_9);
*/

AnalogIn cptGauche(PA_1);
AnalogIn cptDroit(PA_0);
DigitalIn pressionGauche(PA_8);
DigitalIn pressionDroit(PB_7);
    



CAN can1(PA_11,PA_12); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN

signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN

extern "C" void mbed_reset();//Pour pouvoir reset la carte

E_GameEtat carte_etat = ETAT_ATTENTE;
E_Couleur couleurSelect = BLEU;

AX12 *myAX12;




void canRx_ISR (void)
{
    if (can1.read(msgRxBuffer[FIFO_ecriture])) {
        /*if(msgRxBuffer[FIFO_ecriture].id==RESET_ACTIONNEURS) mbed_reset();
        else FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;*/
        FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
    }
}
int main() {
    char truc = 0;
    
    can1.frequency(1000000); // fréquence de travail 1Mbit/s
    can1.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    
    CANMessage msgTx=CANMessage();
    
    myAX12-> Set_Goal_speed(vitesse);
    myAX12-> Set_Mode(0);        
    
    pc.printf("Hello World\n"); 
    while(1) {
        
        led = ((led == 1)?0:1);
        
        automate_process();
        canProcessRx();
        //SendRawId(cpt); 
        wait(0.5);   
    }
}




int action;
char localAX12 = AX12_POSIOTION_BASSE;
/****************************************************************************************/
/* FUNCTION NAME: automate_process                                                      */
/* DESCRIPTION  : Automate de gestion de la stratégie du robot                          */
/****************************************************************************************/
void automate_process(void){
    SendRawId(carte_etat);
    switch(carte_etat){
        case ETAT_ATTENTE:
        break;
        
        case ETAT_TRAITEMENT_ACTION_AX12:
            switch(action){
                #define ACTION_TOURNER_MODULE_GAUCHE 0x10
                #define ACTION_TOURNER_MODULE_DROIT  0x11
                case ACTION_TOURNER_MODULE_GAUCHE:
                        carte_etat = ETAT_BAISSER_MAIN_GAUCHE;
                break;
                case ACTION_TOURNER_MODULE_DROIT:
                        carte_etat = ETAT_BAISSER_MAIN_DROITE;
                break;
                default:
                    carte_etat = ETAT_ATTENTE;
                }
        break;
    
        case ETAT_BAISSER_MAIN_GAUCHE:
            if(pressionGauche.read() == ENFONCER){
                carte_etat = ETAT_CHECK_COULEUR;
            } else{
                // 
                localAX12 = AX12BaisserMainGauche(localAX12);
            }             
        break;
        
        case ETAT_BAISSER_MAIN_DROITE:
            if(pressionDroit.read() == ENFONCER){
                carte_etat = ETAT_CHECK_COULEUR;
            }else{
                // 
                localAX12 = AX12BaisserMainDroite(localAX12);
            }
        break;
        
        case ETAT_CHECK_COULEUR:
            //if (((unsigned short)cptGauche.read()&(unsigned short)cptDroit.read()) == 0){
            if ((unsigned short)cptDroit.read() == 0){
                carte_etat = ETAT_ATTENTE;
            }else{
                // on active les moteurs
                localAX12 = AX12BaisserMainGauche(localAX12);    
            }
        break;
        
        case ETAT_TURBINE:
            carte_etat = ETAT_ATTENTE;
            turbineWritePWM(50);
        break;
        
        case ETAT_POMPES:
            carte_etat = ETAT_ATTENTE;
            pompeWritePWM(50);
        break;
        
        
        
        default:
            pc.printf("etat non identifie");
        }
    }
    
    
/*********************************************************************************************************/
/* FUNCTION NAME: SendRawId                                                                              */
/* DESCRIPTION  : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendRawId (unsigned short id)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=0;
    can1.write(msgTx);
    wait_us(200);
}


/****************************************************************************************/
/* FUNCTION NAME: canProcessRx                                                          */
/* DESCRIPTION  : Fonction de traitement des messages CAN                               */
/****************************************************************************************/
void canProcessRx(void){
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;
    CANMessage msgTx=CANMessage();
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
    if(FIFO_occupation!=0) {
        
        switch(msgRxBuffer[FIFO_lecture].id) {
            case CHECK_ACTIONNEURS:
                SendRawId(ALIVE_ACTIONNEURS);
            break;
            
            case SERVO_AX12_ACTION : 
                carte_etat = ETAT_TRAITEMENT_ACTION_AX12;
                
                action = msgRxBuffer[FIFO_lecture].data[0];
                couleurSelect = (E_Couleur)msgRxBuffer[FIFO_lecture].data[1];
                //ACK de reception des actions a effectuer
                msgTx.id = ACKNOWLEDGE_AX12;
                msgTx.len = 1;
                msgTx.data[0] = msgRxBuffer[FIFO_lecture].data[0];
                can1.write(msgTx);
            break;
            
            case POMPE_PWM:
                carte_etat = ETAT_POMPES;
            
                msgTx.id = ACKNOWLEDGE_POMPES;
                msgTx.len = 1;
                msgTx.data[0] = msgRxBuffer[FIFO_lecture].data[0];
                can1.write(msgTx);
            break;
            
            #define TURBINE_PWM 0xa1
            #define ACKNOWLEDGE_TURBINE 0x107
            case TURBINE_PWM:
                carte_etat = ETAT_TURBINE;
            
                msgTx.id = ACKNOWLEDGE_TURBINE;
                msgTx.len = 1;
                msgTx.data[0] = msgRxBuffer[FIFO_lecture].data[0];
                can1.write(msgTx);
            break;  
            
        }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
    }

