#include "all_includes.h"

Timer t;
Ticker flipper;

CAN can(p30,p29); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN

Serial pc(USBTX, USBRX);

extern void gerer_turbine(unsigned char pwm_turbine);


PwmOut PompeDroite(p21);
//PwmOut PompeGauche(p22);
PwmOut MotLanceur(p22);
PwmOut turbine(p23);
//PwmOut ServoVanne(p21);

AnalogIn telemetre(p15);

DigitalIn Jack(p25);


DigitalOut led(LED1);
DigitalOut led2(LED2);

unsigned char EtatPompeDroite=0, EtatPompeGauche=0, EtatLanceur=0, EtatAx12=0, ChoixBras=0, ActionAx12=0, EtatTurbine=0, EtatServoVanne=0;
unsigned char action_a_effectuer=0, ActionPompe=0;


/*
DigitalIn IO1(p23);
DigitalIn IO2(p24);
DigitalIn IO3(p25);
DigitalIn IO4(p26);

AnalogIn A_in1(p15);
AnalogIn A_in2(p16);
AnalogIn A_in3(p17);
AnalogIn A_in4(p18);
AnalogIn A_in5(p19);
AnalogIn A_in6(p20);

PwmOut IRL_1(p21);
PwmOut IRL_2(p22);
*/



    
int main() {
    
    can.frequency(1000000); // fréquence de travail 1Mbit/s
    can.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    
    
    // message CAN autorise a declencher l'interruption
    
    CAN2_wrFilter(POMPE_DROITE);
    CAN2_wrFilter(POMPE_GAUCHE);
 
    CAN2_wrFilter(LANCEUR);
    CAN2_wrFilter(TURBINE);
    CAN2_wrFilter(SERVOVANNE);
    CAN2_wrFilter(0x123);
       
    CAN2_wrFilter(SERVO_AX12_ACTION);
    CAN2_wrFilter(SERVO_AX12_ACK);
    CAN2_wrFilter(SERVO_AX12_END);
    CAN2_wrFilter(CHECK_AX12);
    
    initialisation_AX12();
    
    PompeDroite.period(0.001);
    //PompeGauche.period(0.001);
    MotLanceur.period(0.001);
  //  ServoVanne.period(0.001);
    
    
    while(1) {
        led = !led;
        canProcessRx();//Traitement des trames CAN en attente 
        
        
        if (action_a_effectuer==1) {
            
            action_a_effectuer=0;
            
            if (ActionAx12==1){
                AX12_automate(EtatAx12, ChoixBras);
                ActionAx12=0;
            }
            
            if ((EtatPompeDroite==1)&&(ActionPompe==1))
                ActionPompe=0, PompeDroite.write(1); 
            else if ((EtatPompeDroite==0)&&(ActionPompe==1))
                PompeDroite.write(0), ActionPompe=0;
     
            /*
            if (EtatPompeGauche==1)
               PompeGauche.write(1); 
            else if (EtatPompeGauche==0)
               PompeGauche.write(0);
            */
               
            if (EtatTurbine==1)
                gerer_turbine(20);
            else if (EtatTurbine==0)
                gerer_turbine(0);
                
            if (EtatLanceur==1)
                MotLanceur.write(1);
            else if (EtatLanceur==0)
                MotLanceur.write(0); 
            /*
            if (EtatServoVanne==1)
                ServoVanne.write(0.4);
            if (EtatServoVanne==0)
                ServoVanne.write(0);
             */          
        } 
            
    }
}

