#include "all_includes.h"                 
                  
   
   
#define AX12_INITIALISATION 0
#define AX12_PREPARATION_PRISE 1
#define AX12_STOCKAGE_HAUT 2
#define AX12_STOCKAGE_BAS 3
#define AX12_DEPOSER 4
#define AX12_PREPARATION_DEPOT_BAS 5
#define AX12_PREPARATION_DEPOT_HAUT 6
#define AX12_POUSSER_MODULE 7
#define AX12_VIDER_FUSEE_POMPE 8
#define AX12_REMPLIR_BASE_POMPE 9
#define AX12_GET_POSITION 10
#define AX12_VIDER_FUSEE_POMPEBLEU 11
#define BOUGER_MX12 12
#define AX12_DEFAUT 20

#define TOLERANCE_AX12 50
               
         /*       PROTOTYPES DE FONCTIONS ET POINTEURS       */
                    


/****************************************************************************************/
/* FUNCTION NAME: Fin_action                                                            */
/* DESCRIPTION  : Fonction qui confirme la fin de mouvement des AX12                    */
/****************************************************************************************/
void Fin_action(void);


/****************************************************************************************/
/* FUNCTION NAME: Initialisation_position                                               */
/* DESCRIPTION  : Fonction qui place les bras en position verticale                     */
/****************************************************************************************/
void Initialisation_position(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Preparation_prise                                                     */
/* DESCRIPTION  : Fonction qui prepare le robot pour prendre les modules                */
/****************************************************************************************/
void Preparation_prise(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Stockage_haut                                                         */
/* DESCRIPTION  : Fonction qui prend et stocke les modules dans la position haute       */
/****************************************************************************************/
void Stockage_haut(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Stockage_bas                                                          */
/* DESCRIPTION  : Fonction qui prend et stocke un module dans la pince                  */
/****************************************************************************************/
void Stockage_bas(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Deposer                                                               */
/* DESCRIPTION  : Fonction qui permet de déposer un module                              */
/****************************************************************************************/
void Deposer(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Preparation_depos_bas                                                 */
/* DESCRIPTION  : Fonction qui prépare le depos d'un module en bas                      */
/****************************************************************************************/
void Preparation_depot_bas(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Preparation_depos_haut                                                */
/* DESCRIPTION  : Fonction qui prépare le depos d'un module en haut                     */
/****************************************************************************************/
void Preparation_depot_haut(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Pousser_module                                                        */
/* DESCRIPTION  : Fonction qui permet pousser le module situé à l'entrée de la bas      */
/****************************************************************************************/
void Pousser_module(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: bouger_MX12                                                           */
/* DESCRIPTION  : Fonction qui sélectionne le sens de rotation de l'MX12 et le bouge    */
/****************************************************************************************/
void bouger_MX12(unsigned char choix);

/****************************************************************************************/
/* FUNCTION NAME: Check_positionAX12                                                    */
/* DESCRIPTION  : Fonction qui permet de verifier la position des AX12                  */
/****************************************************************************************/
void Check_positionAX12(char* TAB, unsigned char choix);


///////////TABLEAU PINCE DROITE /////////////////////////// --> choix_bras == 1
static char TAB1[25]=   {0x12,0xDA, 0x00, 0xFF, 0x00,               ///Position initiale          
                         0x04,0xF4, 0x01, 0xFF, 0x00,
                         0x07,0x00, 0x01, 0xFF, 0x00,
                         0x0F,0x00, 0x03, 0xFF, 0x00};                              

static char TAB2[25]=   {0x12,0xFF, 0x02, 0xFF, 0x03,               ///Preparation prise              
                         0x04,0xE9, 0x00, 0xFF, 0x03,
                         0x07,0xF4, 0x01, 0xFF, 0x03,
                         0x0F,0xF4, 0x01, 0xFF, 0x03};
                         
static char TAB3[25]=   {0x12,0xFF, 0x02, 0xFF, 0x03,               ///Stockage haut/bas (attraper module)            
                         0x04,0xE9, 0x00, 0xFF, 0x03,
                         0x07,0xD5, 0x00, 0xFF, 0x00,
                         0x0F,0x4D, 0x03, 0xFF, 0x00}; 

static char TAB4[25]=   {0x12,0x35, 0x01, 0xFF, 0x03,               ///Stockage haut (bras en l'air)   
                         0x04,0x00, 0x02, 0xFF, 0x03,
                         0x07,0xD5, 0x00, 0xFF, 0x00,
                         0x0F,0x4D, 0x03, 0xFF, 0x00}; 
                         
static char TAB5[25]=   {0x12,0x35, 0x01, 0xFF, 0x00,               ///Stockage haut (module sur tige)              
                         0x04,0x60, 0x01, 0xFF, 0x00,
                         0x07,0xD5, 0x00, 0xFF, 0x00,
                         0x0F,0x4D, 0x03, 0xFF, 0x00};  
                         
static char TAB6[25]=   {0x12,0x35, 0x01, 0xFF, 0x03,               ///Stockage haut (pince ouverte)            
                         0x04,0x50, 0x01, 0xFF, 0x03,
                         0x07,0x0A, 0x01, 0xFF, 0x03,
                         0x0F,0xDD, 0x02, 0xFF, 0x03}; 
                         
static char TAB7[25]=   {0x12,0xA6, 0x00, 0xFF, 0x03,               ///Stockage bas (bras en l'air)              
                         0x04,0x50, 0x03, 0xFF, 0x03,
                         0x07,0xD5, 0x00, 0xFF, 0x03,
                         0x0F,0x4D, 0x03, 0xFF, 0x03};  
                         
static char TAB8[25]=   {0x12,0xF4, 0x01, 0xFF, 0x00,               ///Deposer (descendre bras)            
                         0x04,0x00, 0x03, 0xFF, 0x00,
                         0x07,0xD5, 0x00, 0xFF, 0x00,
                         0x0F,0x4D, 0x03, 0xFF, 0x00}; 
                         
static char TAB9[25]=   {0x12,0xF4, 0x01, 0xFF, 0x03,               ///Deposer (pince ouverte)            
                         0x04,0x00, 0x03, 0xFF, 0x03,
                         0x07,0x0A, 0x01, 0xFF, 0x03,
                         0x0F,0xDD, 0x02, 0xFF, 0x03}; 
                         
static char TAB10[25]=   {0x12,0x35, 0x01, 0xFF, 0x00,               ///deposer (preparation module haut)              
                         0x04,0x00, 0x02, 0xFF, 0x00,
                         0x07,0xD5, 0x00, 0xFF, 0x00,
                         0x0F,0x4D, 0x03, 0xFF, 0x00}; 
                         
static char TAB11[25]=   {0x12,0xB0, 0x01, 0xFF, 0x00,               ///Pousser module (bras en bas)            
                         0x04,0x00, 0x03, 0xFF, 0x00,
                         0x07,0x0A, 0x01, 0xFF, 0x03,
                         0x0F,0xDD, 0x02, 0xFF, 0x03};                                                                         
                         
                         
//////////////////TABLEAU PINCE GAUCHE /////////////////////////////    --> choix_bras == 2
static char TAB21[25]=   {0x08,0xDA, 0x00, 0xFF, 0x00,               ///Position initiale          
                         0x03,0xF4, 0x01, 0xFF, 0x00,
                         0x0D,0x00, 0x01, 0xFF, 0x00,
                         0x0E,0x00, 0x03, 0xFF, 0x00};                              

static char TAB22[25]=   {0x08,0xFF, 0x02, 0xFF, 0x03,               ///Preparation prise              
                         0x03,0xE9, 0x00, 0xFF, 0x03,
                         0x0D,0xF4, 0x01, 0xFF, 0x03,
                         0x0E,0xF4, 0x01, 0xFF, 0x03};
                         
static char TAB23[25]=   {0x08,0xFF, 0x02, 0xFF, 0x03,               ///Stockage haut/bas (attraper module)            
                         0x03,0xE9, 0x00, 0xFF, 0x03,
                         0x0D,0xD5, 0x00, 0xFF, 0x00,
                         0x0E,0x4D, 0x03, 0xFF, 0x00};  

static char TAB24[25]=   {0x08,0x35, 0x01, 0xFF, 0x03,               ///Stockage haut (bras en l'air)   
                         0x03,0x00, 0x02, 0xFF, 0x03,
                         0x0D,0xD5, 0x00, 0xFF, 0x00,
                         0x0E,0x4D, 0x03, 0xFF, 0x00};  
                         
static char TAB25[25]=   {0x08,0x35, 0x01, 0xFF, 0x00,               ///Stockage haut (module sur tige)              
                         0x03,0x60, 0x01, 0xFF, 0x00,
                         0x0D,0xD5, 0x00, 0xFF, 0x00,
                         0x0E,0x4D, 0x03, 0xFF, 0x00};  
                         
static char TAB26[25]=   {0x08,0x35, 0x01, 0xFF, 0x03,               ///Stockage haut (pince ouverte)            
                         0x03,0x50, 0x01, 0xFF, 0x03,
                         0x0D,0x0A, 0x01, 0xFF, 0x03,
                         0x0E,0xDD, 0x02, 0xFF, 0x03}; 
                         
static char TAB27[25]=   {0x08,0xA6, 0x00, 0xFF, 0x03,               ///Stockage bas (bras en l'air)              
                         0x03,0x50, 0x03, 0xFF, 0x03,
                         0x0D,0xD5, 0x00, 0xFF, 0x03,
                         0x0E,0x4D, 0x03, 0xFF, 0x03}; 
                         
static char TAB28[25]=   {0x08,0xF4, 0x01, 0xFF, 0x00,               ///Deposer(descendre bras)            
                         0x03,0x00, 0x03, 0xFF, 0x00,
                         0x0D,0xD5, 0x00, 0xFF, 0x00,
                         0x0E,0x4D, 0x03, 0xFF, 0x00}; 
                         
static char TAB29[25]=   {0x08,0xF4, 0x01, 0xFF, 0x03,               ///Deposer(pince ouverte)            
                         0x03,0x00, 0x03, 0xFF, 0x03,
                         0x0D,0xF4, 0x01, 0xFF, 0x03,
                         0x0E,0xF4, 0x01, 0xFF, 0x03}; 
                         
static char TAB30[25]=   {0x08,0x35, 0x01, 0xFF, 0x00,               ///deposer(preparation module haut)              
                         0x03,0x00, 0x02, 0xFF, 0x00,
                         0x0D,0xD5, 0x00, 0xFF, 0x00,
                          0x0E,0x4D, 0x03, 0xFF, 0x00};    
                         
static char TAB31[25]=   {0x08,0xB0, 0x01, 0xFF, 0x00,               ///Pousser module (bras en bas)            
                         0x03,0x00, 0x03, 0xFF, 0x00,
                         0x0D,0xD5, 0x00, 0xFF, 0x00,
                         0x0E,0x4D, 0x03, 0xFF, 0x00};  
  
  
char TabBrasPompePosInit[15]=   {0x03,0xB0, 0x01, 0xFF, 0x00,               /// (bras en bas)            
                                 0x02,0x00, 0x03, 0xFF, 0x00,
                                 0x01,0xD5, 0x00, 0xFF, 0x00};  
 /*                                
char TabBrasPompeViderFuseeMvt1[15]=   {0x03,0xFD, 0x01, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0xF3, 0x00, 0xFF, 0x00,
                                    0x01,0x0B, 0x03, 0xFF, 0x00};                                 
                                      
                                 
                                    
char TabBrasPompeViderFuseeMvt2[15]=   {0x03,0x18, 0x02, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0xA9, 0x00, 0xFF, 0x00,
                                    0x01,0xC8, 0x01, 0xFF, 0x00};     
                                    
char TabBrasPompeViderFuseeMvt3[15]=   {0x03,0x3D, 0x03, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x45, 0x00, 0xFF, 0x00,
                                    0x01,0x74, 0x01, 0xFF, 0x00};   
                                    
char TabBrasPompeViderFuseeMvt4[15]=   {0x03,0x7C, 0x03, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x71, 0x00, 0xFF, 0x00,
                                    0x01,0xE5, 0x00, 0xFF, 0x00};    
                                    
char TabBrasPompeViderFuseeMvt5[15]=   {0x03,0x7C, 0x03, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x0D, 0x01, 0xFF, 0x00,
                                    0x01,0x74, 0x00, 0xFF, 0x00};                                    
*/
/*
char TabBrasPompeViderFuseeMvt1[15]=   {0x03,0xCE, 0x01, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0xDB, 0x00, 0xFF, 0x00,
                                    0x01,0x2F, 0x03, 0xFF, 0x00};                                 
                                      
                                 
                                    
char TabBrasPompeViderFuseeMvt2[15]=   {0x03,0x4D, 0x02, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x6D, 0x00, 0xFF, 0x00,
                                    0x01,0x00, 0x02, 0xFF, 0x00};     
                                    
char TabBrasPompeViderFuseeMvt3[15]=   {0x03,0x4D, 0x03, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x4F, 0x00, 0xFF, 0x00,
                                    0x01,0x32, 0x01, 0xFF, 0x00};   
                                    
char TabBrasPompeViderFuseeMvt4[15]=   {0x03,0x5B, 0x03, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0xF3, 0x00, 0xFF, 0x00,
                                    0x01,0x5D, 0x00, 0xFF, 0x00}; 
                                    
char TabBrasPompeViderFuseeMvt5[15]=   {0x03,0x39, 0x03, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x4C, 0x00, 0xFF, 0x00,
                                    0x01,0x80, 0x00, 0xFF, 0x00};   
                                    
char TabBrasPompeViderFuseeMvt6[15]=   {0x03,0xBE, 0x02, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x3F, 0x00, 0xFF, 0x00,
                                    0x01,0x80, 0x00, 0xFF, 0x00};
                                    
char TabBrasPompeViderFuseeMvt7[15]=   {0x03,0x18, 0x02, 0xFF, 0x00,               /// (haut, milieu, bas)            
                                    0x02,0x9C, 0x00, 0xFF, 0x00,
                                    0x01,0xF3, 0x01, 0xFF, 0x00};  
     
     */
    
char TabBrasPompeViderFuseeMvt1[15]=   {0x03,0xE2, 0x01, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0xD5, 0x00, 0xFF, 0x03,
                                    0x01,0xFF, 0x01, 0xFF, 0x03};                                 
                                      
                                 
                                    
char TabBrasPompeViderFuseeMvt2[15]=   {0x03,0xF0, 0x02, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x45,0x00, 0xFF, 0x03,
                                    0x01,0x32,0x03, 0xFF, 0x03};     
                                    
char TabBrasPompeViderFuseeMvt3[15]=   {0x03,0x68,0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x3B, 0x00, 0xFF, 0x03,
                                    0x01,0x98, 0x02, 0xFF, 0x03}; 
                                    
char TabBrasPompeViderFuseeMvt33[15]=   {0x03,0x68,0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x7E, 0x00, 0xFF, 0x03,
                                    0x01,0x65, 0x02, 0xFF, 0x03};                                      
                                    
char TabBrasPompeViderFuseeMvt4[15]=   {0x03,0x65, 0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0xE9, 0x00, 0xFF, 0x03,
                                    0x01,0xFF, 0x01, 0xFF, 0x03}; 
                                    
char TabBrasPompeViderFuseeMvt44[15]=   {0x03,0x34, 0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x88, 0x01, 0xFF, 0x03,
                                    0x01,0x8B, 0x01, 0xFF, 0x03};  
   
   
                                    
char TabBrasPompeViderFuseeMvt2_2[15]=   {0x03,0xF0, 0x02, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x45,0x00, 0xFF, 0x03,
                                    0x01,0xCC,0x00, 0xFF, 0x03};     
                                    
char TabBrasPompeViderFuseeMvt3_2[15]=   {0x03,0x68,0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x3B, 0x00, 0xFF, 0x03,
                                    0x01,0x66, 0x01, 0xFF, 0x03}; 
                                    
char TabBrasPompeViderFuseeMvt33_2[15]=   {0x03,0x68,0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x7E, 0x00, 0xFF, 0x03,
                                    0x01,0x99, 0x01, 0xFF, 0x03};                                      
                                    
char TabBrasPompeViderFuseeMvt4_2[15]=   {0x03,0x65, 0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0xE9, 0x00, 0xFF, 0x03,
                                    0x01,0xFF, 0x01, 0xFF, 0x03}; 
                                    
char TabBrasPompeViderFuseeMvt44_2[15]=   {0x03,0x34, 0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x88, 0x01, 0xFF, 0x03,
                                    0x01,0x98, 0x02, 0xFF, 0x03};                                   
                                    
                                    
                                    
char TabBrasPompeViderFuseeMvt5[15]=   {0x03,0x40, 0x03, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x67, 0x00, 0xFF, 0x03,
                                    0x01,0x32, 0x00, 0xFF, 0x03};   
                                    
char TabBrasPompeViderFuseeMvt6[15]=   {0x03,0x7C, 0x02, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x56, 0x00, 0xFF, 0x03,
                                    0x01,0x32, 0x03, 0xFF, 0x03};
                                    
char TabBrasPompeViderFuseeMvt7[15]=   {0x03,0x14, 0x02, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0x92, 0x00, 0xFF, 0x03,
                                    0x01,0x32, 0x003, 0xFF, 0x03};  
                    
char TabBrasPompeViderFuseeMvt8[15]=   {0x03,0xDC, 0x01, 0xFF, 0x03,               /// (haut, milieu, bas)            
                                    0x02,0xD5, 0x00, 0xFF, 0x03,
                                    0x01,0xFF, 0x01, 0xFF, 0x03};      
                    