#include "main.h"

//initialisations relatives au Bus CAN
CAN bus_can(PB_8,PB_9,1000000);
Serial pc(USBTX,USBRX,115200);
CANMessage rx_message ;
char data[1] = {0x28};
CANMessage tx_message(0x220,data,1,CANData,CANStandard);

int flag_reception_CAN = 0 ;
void interruption_reception(void) ;
void gestion_Message_CAN(void) ;
void Envoi_msg_CAN(char donnee);

CANMessage msgRxBuffer[SIZE_FIFO];
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN
signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN
unsigned short ackFinAction = 0;

bloc_8_pompe::bloc_8_pompe classe_pompe    (PC_9, PA_8, PB_0,       //bloc 1
                                                PA_9, PA_10, PB_1,      //bloc 2
                                                PA_11, PA_15, PC_1,     //bloc 3
                                                PB_7, PB_6, PC_0,       //bloc 4
                                                PC_7, PC_8, PC_5,       //bloc 5
                                                PB_10, PB_2, PC_4,      //bloc 6
                                                PA_6, PA_5, PA_7,       //bloc 7
                                                PA_0, PA_1, PA_4);      //bloc 8

int main (void)
{   
    wait_ms(200); //tempo pour boot
    bus_can.attach(&interruption_reception); //création de l'interrupt attachée à la réception sur le CAN
    //servo_interrupt_en(); //permettre les interuptions
    //activer_torque();
    //wait_ms(200);
    //desactiver_torque();
    pc.printf("\nLAUNCHED\n\r");
    
    while(1)
    {   
        //Envoi_msg_CAN(1);
        wait_ms(100);
        servo_interrupt_en();
        Interrupt2_en();
        pc.printf("Bar_base: %03d Bar_milieu: %03d Bar_haut: %03d \r",getPos(BAR_BASE,2),getPos(BAR_MILIEU,2),getPos(BAR_HAUT,2));
        //Interrupt2_en();
         /*Interrupt2_en();
        printf("Har_base: %d \n",getPos(HAV_BASE,2));
        Interrupt2_en();
        printf("Har_milieu: %d \n",getPos(HAV_MILIEU,2));
        Interrupt2_en();
        printf("Har_haut: %d \n",getPos(HAV_HAUT,2));*/
        if(flag_reception_CAN)
        {
            gestion_Message_CAN();
        }
    }
}

void interruption_reception(void) 
{
    bus_can.write(tx_message);
    bus_can.read(rx_message);
    flag_reception_CAN = 1 ;
}

void gestion_Message_CAN(void) 
{
    int identifiant = rx_message.id ;
    char num_groupe = 1 ;
    char etat_groupe = 0 ;
    
    switch (identifiant) 
    {
        case TORQUE_ACT:
            activer_torque();
            break;
                
        case TORQUE_DESACT:
            desactiver_torque();
            break;
        
        case PRISE_ARRIERE:
            //fct_prise(BAR_BASE, BAR_MILIEU, BAR_HAUT, SERIAL_GAUCHE);
            fct_prise_arriere(SERIAL_DROITE);
            break;
            
        case PRISE_COMPLETE:
            fct_bras_arriere(SERIAL_GAUCHE);
            break;
            
        case CN_OUVERTURE:
            activer_CN();
            break;
            
        case CN_FERMETURE:
            desactiver_CN();
            break;
            
        case VENT_AT:
                num_groupe = rx_message.data[0];
                classe_pompe.aspirer(num_groupe) ;
                break;
                
        case VENT_RE:
        
                num_groupe = rx_message.data[0];
                classe_pompe.relacher(num_groupe) ;
                break; 
                
        case VENT_ETAT:
                num_groupe = rx_message.data[0];
                etat_groupe = classe_pompe.etat_actuel(num_groupe) ;
                
                if(etat_groupe == 0x07)
                {
                    classe_pompe.aspirer(num_groupe) ;
                    etat_groupe = classe_pompe.etat_actuel(num_groupe) ;
                }
                
                
                Envoi_msg_CAN(etat_groupe);
                
                break;
                
        default:
                break;        
    }
    flag_reception_CAN = 0 ;
                
}

void Envoi_msg_CAN(char donnee)
{   
    CANMessage message;
    message.id = 0x220;    
    message.len=1;
    message.format=CANStandard;
    message.type=CANData;
    message.data[0]=donnee;

    bus_can.write(message);
}