#include "mbed.h"
#include "CAN.h"
#include "ident_crac.h"

#define SIZE_FIFO   10 //Taille du buffer pour le bus CAN



/**
Traitement du buffer CAN
**/
void canProcessRx(void);

CAN             can1(PA_11, PA_12); // Rx&Tx pour le CAN
CANMessage      msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN
unsigned char   FIFO_ecriture=0; //Position du fifo pour la reception CAN
unsigned char   FIFO_lecture=0;//Position du fifo de lecture des messages CAN

PwmOut  pompe0(A7);
PwmOut  pompe1(A6);
PwmOut  pompe2(A5);
PwmOut  pompe3(A3);
PwmOut  pompe4(A2);
PwmOut  pompe5(D12);
/****************************************************************************************/
/* FUNCTION NAME: canRx_ISR                                                             */
/* DESCRIPTION  : Interruption en réception sur le CAN                                  */
/****************************************************************************************/
void canRx_ISR (void)
{
    if (can1.read(msgRxBuffer[FIFO_ecriture])) {
        if(msgRxBuffer[FIFO_ecriture].id==RESET_POMPES) NVIC_SystemReset();
        else FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
    }
}

/*********************************************************************************************************/
/* FUNCTION NAME: SendRawId                                                                              */
/* DESCRIPTION  : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendRawId (unsigned short id)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=0;
    can1.write(msgTx);
    
    wait_us(200);
}

void canProcessRx(void)
{
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;

    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
    if(FIFO_occupation!=0) {  
      //  printf("Id:=%d len:=%d",msgRxBuffer[FIFO_lecture].id,msgRxBuffer[FIFO_lecture].len);
        
        switch(msgRxBuffer[FIFO_lecture].id) 
        {
        
            
             /*Check alive*/
            case CHECK_POMPES:
            if(msgRxBuffer[FIFO_lecture].len==0)
            SendRawId(ALIVE_POMPES);
            break;
            
        
            case POMPE_PWM :
                            //pompe0=msgRxBuffer[FIFO_lecture].data[0]/100 ;
                           /* if(inverse==1)
                            inverse=0;
                            else inverse=1 ;
                            pompe0=0 ;*/
                            //affiche=msgRxBuffer[FIFO_lecture].data[0]/100.0 ;
                            //printf("p0 %d \n",inverse);
                            //printf("je passe par la \n");
                            pompe0=(msgRxBuffer[FIFO_lecture].data[0])/100.0 ;
                            pompe1=(msgRxBuffer[FIFO_lecture].data[1])/100.0 ;                    
                            pompe2=(msgRxBuffer[FIFO_lecture].data[2])/100.0 ;
                            
                            //affiche=msgRxBuffer[FIFO_lecture].data[2]/100.0 ;
                            //printf("pwm p2 %f \n",affiche);
                            
                            pompe3=(msgRxBuffer[FIFO_lecture].data[3])/100.0 ;
                            
                            //affiche=msgRxBuffer[FIFO_lecture].data[3]/100.0 ;
                            //printf("pwm p3 %f \n",affiche);
                            
                            pompe4=(msgRxBuffer[FIFO_lecture].data[4])/100.0 ;
                            pompe5=(msgRxBuffer[FIFO_lecture].data[5])/100.0 ;
                            break;
                            
                 default :
                    //printf("ya une couille\r\n");
                    break;
        
        }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
}

int main() {
    can1.frequency(1000000); // fréquence de travail 1Mbit/s
    can1.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    pompe0=0;
    pompe1=0;
    pompe2=0;
    pompe3=0;
    pompe4=0;
    pompe5=0;
    //printf("debut\n\r");
    while(1) 
    { 
        canProcessRx();
    }
}