#include "ident_crac.h"
#include "cyapicallbacks.h"

//----------------------------- constantes -----------------------------------------

#define LARGEUR_ROBOT 324.25
#define PERIMETRE_ROUE_CODEUSE 160.01
#define COEF_ROUE_GAUCHE 1

#define GROS_ROB 1  
    
#define VMAX_DANGER 20.0                   
#define AMAX_DANGER 1.0  
    
#define PI 3.14159265359  
#define RESOLUTION_ROUE_CODEUSE 1024.0 
#define RECALAGE_TH 300
    
#define TYPE_DEPLACEMENT_STOP 0            
#define TYPE_DEPLACEMENT_IMMOBILE 1             
#define TYPE_DEPLACEMENT_LIGNE_DROITE 2
#define TYPE_DEPLACEMENT_ROTATION 3
#define TYPE_DEPLACEMENT_X_Y_THETA 4
#define TYPE_DEPLACEMENT_RAYON_COURBURE 5
#define TYPE_DEPLACEMENT_RECALAGE 6
 
#define INITIALISATION 0
#define ACCELERATION_TRAPEZE 1
#define VITESSE_CONSTANTE_TRAPEZE 2
#define DECELERATION_TRAPEZE 3
#define ARRET 4
#define ACCELERATION_TRIANGLE 5
#define DECELERATION_TRIANGLE 6
    
#define INIT_RECALAGE 0
#define ACCELERATION_RECALAGE 1
#define VITESSE_CONSTANTE_RECALAGE 2
#define FIN_RECALAGE 3
 
#define INIT_X_Y_THETA 0
#define ROTATION_X_Y_THETA_1 1
#define LIGNE_DROITE_X_Y_THETA 2
#define ROTATION_X_Y_THETA_2 3

#define INIT_RAYON_COURBURE 0
#define ACCELERATION_TRAPEZE_RAYON_COURBURE 1
#define VITESSE_CONSTANTE_TRAPEZE_RAYON_COURBURE 2
#define DECELERATION_TRAPEZE_RAYON_COURBURE 3
#define ARRET_RAYON_COURBURE 4
#define ACCELERATION_TRIANGLE_RAYON_COURBURE 5
#define DECELERATION_TRIANGLE_RAYON_COURBURE 6

//----------------------------- nouveaux types -----------------------------------------

struct Ordre_deplacement
{
    char type, enchainement;
    short vmax, amax;
    short distance, recalage, val_recalage;
    long angle;
    short x, y, theta;
    signed char sens;
    short rayon, vit_ray, theta_ray;
};

//----------------------------- prototypes de fcts -----------------------------------------

void write_PWM1(double vit);
void write_PWM2(double vit);


//----------------- DECLARATIONS EXTERN de var globales (definies dans main.cpp) ---------------------

extern PwmOut mot1;     // attention pour la decl d'objet : pas de pin / d'initialisation
extern PwmOut mot2;   

extern DigitalOut INA_M2;    
extern DigitalOut INB_M2;
extern DigitalOut INA_M1;
extern DigitalOut INB_M1 ;

extern double test1;        // attention pour la decl de var : pas d'initialisation
extern double test2; 

extern double   consigne_pos, consigne_vit,                 // Consignes de position et de vitesse dans les mouvements
                commande1, commande2,                       // Commande, aka duty cycle des PWM de chaque moteur
                last_pos1, last_pos2, pos1, pos2,           // Valeurs des compteurs incrémentaux aux instants t et t-1
                ErreurPos1, ErreurPos2, last_ErreurPos1, last_ErreurPos2,       // Valeurs des erreurs de position de la boucle d'asservissement
                Somme_ErreurPos1, Somme_ErreurPos2,                             // Valeurs des intégrales des erreurs
                Delta_ErreurPos1, Delta_ErreurPos2,                             // Valeurs des dérivées des erreurs
                Kpp1, Kip1, Kdp1, Kpp2, Kip2, Kdp2,                             // Valeurs des correcteurs d'asservissement pour les 2 moteurs
                Kpp1a, Kip1a, Kdp1a, Kpp2a, Kip2a, Kdp2a,                       // Valeurs des correcteurs d'asservissement pour les 2 moteurs
                VMAX, AMAX, DMAX,                                               // Valeurs maximales d'accéleration, décélération et vitesse
                Odo_x, Odo_y, Odo_theta, Odo_val_pos_1, Odo_val_pos_2, Odo_last_val_pos_1, Odo_last_val_pos_2;  // Variables de positions utilisées pour l'odométrie
extern uint32_t                 roue_drt_init, roue_gch_init;                                   // Valeur des compteurs (!= 0) quand on commence un nouveau mouvement
extern short    etat_automate, etat_automate_depl, new_message,
                xytheta_sens, next_move_xyt, next_move, i, cpt, stop, stop_receive, param_xytheta[3],
                etat_automate_xytheta, ralentare, recalage_debut, couleur_debut, recalage_debut_receive;
extern char     nb_ordres, vitesse_danger, Stop_Danger, cpt_ordre, asser_actif;
extern struct Ordre_deplacement liste[200];

