#ifndef ENCODER_H
#define ENCODER_H
#include "mbed.h"
#include "CAN.h"
/*
#include "mbed.h"
#include "Nucleo_Encoder_16_bits.h"
#include "CAN.h"


 * HAL_TIM_Encoder_MspInit()
 * Overrides the __weak function stub in stm32f4xx_hal_tim.h
 *
 * Edit the below for your preferred pin wiring & pullup/down
 * I have encoder common at 3V3, using GPIO_PULLDOWN on inputs.
 * Encoder A&B outputs connected directly to GPIOs.
 *
 * www.st.com/st-web-ui/static/active/en/resource/technical/document/datasheet/DM00102166.pdf
 * www.st.com/st-web-ui/static/active/en/resource/technical/document/datasheet/DM00141306.pdf
 *
 * TIM1_CH1: AF1 @ PA_8, PE_9 
 * TIM1_CH2: AF1 @ PA_9, PE_11 
 *
 * TIM2_CH1: AF1 @ PA_0, PA_5, PA_15, PB_8*     *F446 only
 * TIM2_CH2: AF1 @ PA_1, PB_3, PB_9*            *F446 only
 *
 * TIM3_CH1: AF2 @ PA_6, PB_4, PC_6
 * TIM3_CH2: AF2 @ PA_7, PB_5, PC_7
 *
 * TIM4_CH1: AF2 @ PB_6, PD_12
 * TIM4_CH2: AF2 @ PB_7, PD_13
 *
 * TIM5_CH1: AF2 @ PA_0*    *TIM5 used by mbed system ticker so unavailable
 * TIM5_CH2: AF2 @ PA_1*
 *
 


//STM mbed bug: these macros are MISSING from stm32f3xx_hal_tim.h
#ifdef TARGET_STM32F3
#define __HAL_TIM_GET_COUNTER(__HANDLE__) ((__HANDLE__)->Instance->CNT)
#define __HAL_TIM_IS_TIM_COUNTING_DOWN(__HANDLE__)            (((__HANDLE__)->Instance->CR1 &(TIM_CR1_DIR)) == (TIM_CR1_DIR))
#endif
#define PERIMETRE_ROUE_CODEUSE 160.0
#define LARGEUR_ROBOT 270.0
#define PI 3.14159265359
#define RESOLUTION_ROUE_CODEUSE 1024.0


Nucleo_Encoder_16_bits encoder1(TIM3, 0xffff, TIM_ENCODERMODE_TI12);
Nucleo_Encoder_16_bits encoder2(TIM1, 0xffff, TIM_ENCODERMODE_TI12);

int cpt = 0, dist_d, dist_g;
double D, theta, x, y;

int main()
{    
    printf("Debut du prog");

    
    while(1)
    {
        wait_ms(10);
        dist_d = encoder1.GetCounter() - dist_d;
        dist_g = encoder2.GetCounter() - dist_g;
        D = 0.5 * (dist_d + dist_g);
        theta += 0.5 * (dist_d - dist_g) * 360.0 * PERIMETRE_ROUE_CODEUSE/(LARGEUR_ROBOT*PI*RESOLUTION_ROUE_CODEUSE);
        x = D * cos(theta * PI / 180.0) * PERIMETRE_ROUE_CODEUSE / RESOLUTION_ROUE_CODEUSE;
        y = D * sin(theta * PI / 180.0) * PERIMETRE_ROUE_CODEUSE / RESOLUTION_ROUE_CODEUSE;
        cpt ++;
        if(cpt >= 50)
        {
            printf("\n\rX : %d\n\rY : %d\n\rTheta : %d\n\r**********\n\r", (int)x, (int)y, (int)theta);    
        }
    }

}
*/

void EncoderInit(TIM_Encoder_InitTypeDef * encoder, TIM_HandleTypeDef * timer, TIM_TypeDef * TIMx, uint32_t maxcount, uint32_t encmode);


namespace mbed{
    
    class Nucleo_Encoder_16_bits {
        
        public :
            Nucleo_Encoder_16_bits(TIM_TypeDef * _TIM);
            Nucleo_Encoder_16_bits(TIM_TypeDef * _TIM, uint32_t _maxcount, uint32_t _encmode);
            Nucleo_Encoder_16_bits(TIM_Encoder_InitTypeDef * _encoder, TIM_HandleTypeDef * _timer, TIM_TypeDef * _TIM, uint32_t _maxcount, uint32_t _encmode);
            int32_t GetCounter();
            TIM_HandleTypeDef* GetTimer();
        
        private :
        
        
        protected :
            TIM_Encoder_InitTypeDef encoder;
            TIM_HandleTypeDef timer;
            TIM_TypeDef * TIM;
        
    };

}// namespace mbed

#endif