#include "extern.h"
#define SIZE_FIFO 50


CANMessage msgRxBuffer[SIZE_FIFO];
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN
signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN
char end_game = 0;

Ventouse* ventouse[NB_VENTOUSES];

BusIn contacts(PC_11, PC_12, PB_4, PB_5, PC_13, PC_14, PC_2, PC_3); 
DigitalIn Contact1(PC_11, PullNone);
DigitalIn Contact2(PC_12, PullNone);
DigitalIn Contact3(PB_4, PullNone);
DigitalIn Contact4(PB_5, PullNone);
DigitalIn Contact5(PC_13, PullNone);
DigitalIn Contact6(PC_14, PullNone);
DigitalIn Contact7(PC_2, PullNone);
DigitalIn Contact8(PC_3, PullNone);

void lecture_contacts(void);
void get_etat_ventouses();


CAN can(PB_8,PB_9,1000000);
Serial pc(USBTX,USBRX);

/*********************************************************************************************************/
/* FUNCTION NAME: canRx_ISR                                                                              */
/* DESCRIPTION  : lit les messages sur le can et les stocke dans la FIFO                                 */
/*********************************************************************************************************/
void canRx_ISR (void)
{
    if (can.read(msgRxBuffer[FIFO_ecriture]))
        FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
}


/*********************************************************************************************************/
/* FUNCTION NAME: canProcessRx                                                                           */
/* DESCRIPTION  : Fonction de traitement des messages CAN                                                */
/*********************************************************************************************************/
void canProcessRx(void)
{
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;
    CANMessage msgTx=CANMessage();
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
    if(FIFO_occupation!=0) {
    int identifiant=msgRxBuffer[FIFO_lecture].id;
    char BRAS_VENTOUSE = 0;
    
        switch(identifiant)
        {  
             
            case VENT_AT:
                BRAS_VENTOUSE = msgRxBuffer[FIFO_lecture].data[0];
                ventouse[BRAS_VENTOUSE]->action(1);
                break;
                
            case VENT_RE:
                BRAS_VENTOUSE = msgRxBuffer[FIFO_lecture].data[0];
                ventouse[BRAS_VENTOUSE]->action(0);
                break;   
            
            case VENT_ETAT:
                get_etat_ventouses();
                break;
            
            case GLOBAL_GAME_END:
                end_game = 1;
                break;
                
            case TEST_VENT_1_ON:
                ventouse[AV_DROIT]->action(1);
                ventouse[AV_CENTRE]->action(1);
                ventouse[AV_GAUCHE]->action(1);
                ventouse[AR_DROIT]->action(1);
                ventouse[AR_CENTRE]->action(1);
                ventouse[AR_GAUCHE]->action(1);
                break;
            
            case TEST_VENT_1_OFF:
                ventouse[AV_CENTRE]->action(0);
                ventouse[AV_GAUCHE]->action(0);
                ventouse[AR_DROIT]->action(0);
                ventouse[AR_CENTRE]->action(0);
                ventouse[AR_GAUCHE]->action(0);
                ventouse[AV_DROIT]->action(0);
                break;
            default:
                break;
                      
            }
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
}

int main() {
    
    can.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    wait_ms(100);
    
    ventouse[AV_DROIT] = new Ventouse(PB_7, PB_6, PC_0, AR_DROIT);
    ventouse[AV_GAUCHE] = new Ventouse(PC_9, PA_8, PB_0, AR_CENTRE);
    ventouse[AV_CENTRE] = new Ventouse(PA_9, PA_10,  PB_1, AR_GAUCHE);
    
    ventouse[AR_DROIT] = new Ventouse(PA_0, PA_1, PA_4, AV_DROIT);
    ventouse[AR_CENTRE] = new Ventouse(PB_10, PB_2, PC_4, AV_CENTRE);
    ventouse[AR_GAUCHE] = new Ventouse(PC_7,PC_8 , PC_5, AV_GAUCHE);
    
    pc.printf("Launched carte ventouse");
    //on force les ventouses à être éteintes au début
    ventouse[AV_DROIT]->action(0);
    ventouse[AV_CENTRE]->action(0);
    ventouse[AV_GAUCHE]->action(0);
    ventouse[AR_DROIT]->action(0);
    ventouse[AR_CENTRE]->action(0);
    ventouse[AR_GAUCHE]->action(0);
    while(1) 
    {
        canProcessRx();
        for(int i=0; i<NB_VENTOUSES; i++)
        {
            ventouse[i]->automate();
        }            
        //lecture_contacts();
        if(end_game)
        {
            for(int i=0; i<NB_VENTOUSES;i++)
            {
                ventouse[i]->setPompe(0.0);
                ventouse[i]->setElectrovanne(0);
            }
            while(1);
        }
    }
}

void lecture_contacts(void)
{
    static char prev_contacts = contacts;  
    if(contacts != prev_contacts)
    {
        prev_contacts = contacts;
    }
}

void get_etat_ventouses()
{   
    CANMessage etat_ventouses = CANMessage();      
    etat_ventouses.len=2;
    etat_ventouses.format=CANStandard;
    etat_ventouses.type=CANData;
    etat_ventouses.data[0]=0;
    etat_ventouses.data[0]=1;
    for(int i = (NB_VENTOUSES - 1); i >= 0; i--)
    {
        etat_ventouses.data[0] = (etat_ventouses.data[0]<<1) + ventouse[i]->getPompe();
        etat_ventouses.data[1] = (etat_ventouses.data[1]<<1) + ventouse[i]->getPression();       
    }
    can.write(etat_ventouses);
}