#ifndef CLASS_VENTOUSE_H
#define CLASS_VENTOUSE_H
#include "extern.h"

#define NB_VENTOUSES 6

typedef enum {Attente, Attraper, Attraper_ok, Relacher, Relacher_ok} type_etat ;

class Ventouse{
public:
    Ventouse(PinName pinPompe, PinName pinElectrovanne, PinName pinCapteurPression, char index);
    
    void automate();
    void action(bool action);
    void attraper();
    void relacher();
    
    bool getPression();
    bool getPompe();
    
    void setPompe(float val);
    void setElectrovanne(int val);
    

private:
    PwmOut* m_pompe;
    PwmOut* m_electrovanne;
    AnalogIn* m_pression;
    
    bool flag_electrovanne;
    bool flag_attraper;
    bool flag_relacher;
    type_etat etat;
    char m_index;
    char m_ack;
    
    PinName m_pinPompe, m_pinElectrovanne, m_pinCapteurPression;
};
#endif //CLASS_VENTOUSE_H