#include "global.h"

#ifdef ROBOT_SMALL


unsigned char isStopEnable = 1;//Permet de savoir si il faut autoriser le stop via les balises
//unsigned short telemetreDistance;


/****************************************************************************************/
/* FUNCTION NAME: doFunnyAction                                                         */
/* DESCRIPTION  : Permet de faire la funny action en fin de partie                      */
/****************************************************************************************/
void doFunnyAction(void)
{


}


/*************************************************************************************************/
/* FUNCTION NAME: doAction                                                                       */
/* DESCRIPTION  : Effectuer une action specifique correspondant au numéro dans le fichier strat  */
/*************************************************************************************************/
unsigned char doAction(unsigned char id, unsigned short arg1, short arg2)
{
    int retour = 1;
    CANMessage msgTx=CANMessage();
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    switch(id) {
        case 101: //bras gabarit
            SendRawId(GABARIT_PETIT_ROBOT);
            break;
        case 102: //attraper presentoir avant
            SendRawId(PRESENTOIR_AVANT);
            break;
        case 103: //attraper presentoir arriere
            SendRawId(PRESENTOIR_ARRIERE);
            break;
        case 104: //balance avant
            SendRawId(BALANCE_AVANT);
            break;
        case 105: //balance arriere
            SendRawId(BALANCE_ARRIERE);
            break;
        case 106: //accelerateur avant
            //SendRawId(ACCELERATEUR_AVANT);
            unsigned short distance_recalage=arg1;
            unsigned short distance_revenir=arg2;
            Send2Short(ACCELERATEUR_AVANT, distance_recalage,distance_revenir);
            break;
        case 107: //accelerateur arriere
            SendRawId(ACCELERATEUR_ARRIERE);
            break;
        case 108: //goldenium avant
            //SendRawId(GOLDENIUM_AVANT);
            unsigned short distance_goldenium=arg1;
            Send2Short(GOLDENIUM_AVANT, distance_goldenium,0);
            break;
        case 109: //goldenium arriere
            SendRawId(GOLDENIUM_ARRIERE);
            break;
        case 110: //sol avant
            SendRawId(SOL_AVANT);
            break;
        case 111: //sol arriere
            SendRawId(SOL_ARRIERE);
            break;
        case 112: //sol avant relache
            SendRawId(SOL_AVANT_RELACHE);
            break;
        case 113: //sol arriere relache
            SendRawId(SOL_ARRIERE_RELACHE);
            break;
        case 114:
            SendRawId(AVANT_RELACHE);
            break;

        case 115:
            SendRawId(ARRIERE_RELACHE);
            break;

        case 116:
            unsigned char arg_tempo;
            if(InversStrat == 1)
            {
                switch(arg1){
                    case AV_DROIT:
                        arg_tempo = AV_GAUCHE;
                        break;
                    case AV_GAUCHE:
                        arg_tempo = AV_DROIT;
                        break;
                    case AR_DROIT:
                        arg_tempo = AR_GAUCHE;
                        break;
                    case AR_GAUCHE:
                        arg_tempo = AR_DROIT;
                        break;
                    default :
                        arg_tempo =(unsigned char)arg1;
                        break;
                }
                    
            }
            else arg_tempo =(unsigned char)arg1;

            SendMsgCan(HACHEUR_RELEASE_ATOM, &arg_tempo,1);
            waitingAckFrom = 0;
            waitingAckID =0;
            break;
        case 117:
            SendRawId(RECROQUEVILLER);
            break;
        case 118:
            SendRawId(VENTOUSE_AV_CENTRE_BALANCE);
            break;
        case 119:
            SendRawId(VENTOUSE_AR_CENTRE_BALANCE);
            break;
        case 120:
            SendRawId(ACCELERATEUR_INSERTION_AVANT_GAUCHE);
            break;
            
        case 121:
            SendRawId(ACCELERATEUR_INSERTION_ARRIERE_GAUCHE);
            break;
            
        case 150:
            SCORE_PR+=arg1;
            liaison_Tx.envoyer_short(0x30,SCORE_PR);
            waitingAckFrom = 0;
            waitingAckID = 0;
            break;


        case 200 :
            SendRawId(DATA_TELEMETRE);
            /*telemetreDistance = dataTelemetre();
            wait_ms(1);
            telemetreDistance = dataTelemetre();
            telemetreDistance = telemetreDistance - 170;*/
            break;

        case 201 :
            SendRawId(0x99);
            retour = 2;
            break;

        case 10://Désactiver le stop
            isStopEnable = 0;
            break;
        case 11://Activer le stop saut de strat
            isStopEnable = 1;
            break;
        
        case 12://Activer le stop avec evitement
            isStopEnable = 2;
            break;
            
        
        case 20://Désactiver l'asservissement
            setAsservissementEtat(0);
            break;
        case 21://Activer l'asservissement
            setAsservissementEtat(1);
            break;

        case 22://Changer la vitesse du robot
            // SendSpeed(arg1,(unsigned short)arg2);
            wait_us(200);
            waitingAckFrom = 0;
            waitingAckID = 0;
            break;

        case 19: // CHANGER LA VITESSE + DECELERATION
            //SendSpeedDecel(arg1,(unsigned short) arg2);
            wait_us(200);
            waitingAckFrom = 0;
            waitingAckID =0;
            break;

        case 30://Action tempo
            wait_ms(arg1);
            break;

        default:
            retour = 0;//L'action n'existe pas, il faut utiliser le CAN

    }
    return retour;//L'action est spécifique.

}



/****************************************************************************************/
/* FUNCTION NAME: needToStop                                                            */
/* DESCRIPTION  : Savoir si il faut autoriser le stop du robot via balise               */
/****************************************************************************************/
unsigned char needToStop(void)
{
    return isStopEnable;
}

/****************************************************************************************/
/* FUNCTION NAME: doBeforeEndAction                                                     */
/* DESCRIPTION  : Terminer les actions du robot 1s avant la fin du match                */
/****************************************************************************************/
void doBeforeEndAction(void)
{

}

#endif
