#include "global.h"




void debug_Instruction(struct S_Instruction instruction)
{
    printf("\n********* Debug instruction *********\n");
    
    printf("* Line      => %d\n", instruction.lineNumber);
    printf("* Type      => %s\n", InstructionTypeToString(instruction.order));
    printf("* Direction => %s\n", InstructionDirectionToString(instruction.direction));
    
    printf("* Arg1      => %d\n", instruction.arg1);
    printf("* Arg2      => %d\n", instruction.arg2);
    printf("* Arg3      => %d\n", instruction.arg3);
    
    printf("* Recalage  => %s\n", InstructionPrecisionOuRecalageToString(instruction.precision));
    printf("* NextAction=> %s\n", InstructionNextActionTypeToString(instruction.nextActionType));
    printf("* JumpAction=> %s\n", InstructionNextActionJumpTypeToString(instruction.jumpAction));
    
    printf("* JumpTimeOrX   => %d\n", instruction.JumpTimeOrX);
    printf("* JumpY         => %d\n", instruction.JumpY);
    printf("* nextLineOK    => %d\n", instruction.nextLineOK);
    printf("* nextLineError => %d\n", instruction.nextLineError);
    
    printf("*************************************\n");
}

char* InstructionTypeToString(enum E_InstructionType type)
{
    switch(type)
    {
        case MV_COURBURE:       return "Courbure";
        case MV_LINE:           return "Ligne";
        case MV_TURN:           return "Rotation";
        case MV_XYT:            return "Position XYT";
        case MV_RECALAGE:       return "Recalage";
        case ACTION:            return "Action";
        default:                return "Inconnue";
    }    
}
char* InstructionDirectionToString(enum E_InstructionDirection type)
{
    switch(type)
    {
        case BACKWARD:      return "en arriere";
        case FORWARD:       return "en avant";
        case RELATIVE:      return "relatif";
        case ABSOLUTE:      return "absolu";
        default:            return "absent";
    }    
}
char* InstructionPrecisionOuRecalageToString(enum E_InstructionPrecisionOuRecalage type)
{
    switch(type)
    {
        case PRECISION:     return "correction position en fin de mouvement";
        case RECALAGE_X:    return "recalage en X";
        case RECALAGE_Y:    return "recalage en Y";
        default:            return "absent";
    }    
}
char* InstructionNextActionTypeToString(enum E_InstructionNextActionType type)
{
    switch(type)
    {
        case JUMP:          return "jump";
        case WAIT:          return "attente fin instruction";
        case ENCHAINEMENT:  return "enchainement";
        default:            return "absent";
    }    
}
char* InstructionNextActionJumpTypeToString(enum E_InstructionNextActionJumpType type)
{
    switch(type)
    {
        case JUMP_TIME:         return "attente temps";
        case JUMP_POSITION:     return "attente position";
        default:                return "absent";
    }    
}

void errorLoop(void) {
    while(true) {
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
        
    }
}

void errorInstructionLoop(void) {
    while(true) {
        led2 = 1;
        wait(0.2);
        led2 = 0;
        wait(0.2);
    }
}

/****************************************************************************************/
/* FUNCTION NAME: sendStratEtat                                                         */
/* DESCRIPTION  : permet le debug de l'etat de l'automate de stratégie                  */
/****************************************************************************************/
void sendStratEtat(unsigned char etat, unsigned char currentInstruction) {
    
    CANMessage msgTx=CANMessage();
    msgTx.id=DEBUG_STRATEGIE_AUTOMATE; // tx nouvelle position en (x,y,theta)
    msgTx.len=1;
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    // x sur 2 octets
    msgTx.data[0]=(unsigned char)etat;
    msgTx.data[1]=(unsigned char)currentInstruction;

    can1.write(msgTx);
}

void debugXYTTarget(signed short target_x_robot, signed short target_y_robot, signed short target_theta_robot) {
    printf("going to new position x: %d, y: %d, t: %d\n",target_x_robot,target_y_robot,target_theta_robot);
}

  