#ifndef CRAC_IDENTH
#define CRAC_IDENTH

#define GLOBAL_GAME_END 0x004  // Stop fin du match
#define GLOBAL_START 0x002  // Start
#define GLOBAL_END_INIT_POSITION 0x005  // Fin positionnement robot avant depart
#define GLOBAL_FUNNY_ACTION 0x007  // Funny action start  (0: start, 1: stop)
#define GLOBAL_JACK 0x008
#define ACKNOWLEDGE_JACK 0X009

#define BALISE_STOP 0x003  // Trame stop

#define BALISE_DANGER 0xA  // Trame danger

#define BALISE_END_DANGER 0xB  // Trame fin de danger


#define ASSERVISSEMENT_STOP 0x001  // Stop moteur
#define ASSERVISSEMENT_SPEED_DANGER 0x006  // Vitesse de danger

#define ASSERVISSEMENT_XYT 0x020  // Asservissement (x,y,theta)  (0 : au choix 1 : avant -1 : arrière)
#define ASSERVISSEMENT_XYT_ROTATE 0x030//premiere rotation durant xy theta
#define ASSERVISSEMENT_XYT_LINE 0x040//ligne droite durant xy theta


#define ASSERVISSEMENT_COURBURE 0x021  // Asservissement rayon de courbure  (+ gauche, - droite , sens : 1avt , -1arr; enchainement => 1 oui, 0 => non, 2=>derniére instruction de l'enchainement)
#define ASSERVISSEMENT_CONFIG 0x022  // Asservissement paramètre  (définir les valeurs de vitesse max et d'eccélération max)
#define ASSERVISSEMENT_ROTATION 0x023  // Asservissement rotation
#define ASSERVISSEMENT_RECALAGE 0x024  // Moteur tout droit  (recalage : 0 mouvement seul, 1 x, 2y valeur : coordonnée à laquelle est recalé x/y; enchainement => 1 oui, 0 => non)
#define ACTION_BIG_DEMARRAGE 0x025  // Action de départ du GR  (Lancement de la trajectoire de départ du GR)
#define ODOMETRIE_BIG_POSITION 0x026  // Odométrie position robot  (Position actuel du robot)
#define ODOMETRIE_BIG_VITESSE 0x027  // Odométrie vitesse  (Indication sur l'état actuel)
#define ODOMETRIE_SMALL_POSITION 0x028  // Odométrie position robot  (Position actuel du robot)
#define ODOMETRIE_SMALL_VITESSE 0x029  // Odométrie vitesse  (Indication sur l'état actuel)



#define ASSERVISSEMENT_CONFIG_DECEL 0x019 // Asservissement paramètre  (définir les valeurs de vitesse max et de decélération max)


//////////////////////////////////////////////////////////RESETS///////////////////////////////////////////////////
#define RESET_BALISE 0x030  // Reset balise
#define RESET_MOTEUR 0x031  // Reset moteur
#define RESET_IHM 0x032  // Reset écran tactile
#define RESET_ACTIONNEURS 0x033  // Reset actionneurs
#define RESET_POMPES 0x034  // Reset pompes
#define RESET_AX12 0x035  // Reset AX12
#define RESET_TELEMETRE 0x036 // Reset telemetre



#define RESET_STRAT 0x3A  // Reset stratégie

//////////////////////////////////////////////////////////CHECK CARTES/////////////////////////////////////////////////
#define CHECK_BALISE 0x060  // Check balise
#define CHECK_MOTEUR 0x061  // Check moteur
#define CHECK_IHM 0x062  // Check écran tactile
#define CHECK_ACTIONNEURS_AVANT 0x063  // Check actionneurs
#define CHECK_ACTIONNEURS_ARRIERE 0x064  // Check pompes
#define CHECK_AX12 0x065  // Check AX12
#define CHECK_OK_TELEMETRE 0x066 // Check telemetre

//////////////////////////////////////////////////////////ACK CARTES///////////////////////////////////////////////////
#define ALIVE_BALISE 0x070  // Alive balise
#define ALIVE_MOTEUR 0x071  // Alive moteur
#define ALIVE_IHM 0x072  // Alive écran tactile
#define ALIVE_ACTIONNEURS_AVANT 0x073  // Alive actionneurs
#define ALIVE_ACTIONNEURS_ARRIERE 0x074  // Alive pompes
#define ALIVE_HERKULEX 0x075  // Alive AX12
#define ALIVE_TELEMETRE 0x076 // Alive telemetre


/////////////////////////////////////////////////////ACTIONS COMPLEXES/////////////////////////////////////////////////
#define MONTER_IMMEUBLE_DOUBLE 0x090  // Monte deux immeubles selon un code couleur
#define MONTER_IMMEUBLE 0x091
#define ACK_ACTION 0x99 //autre action possible via les herkulex, ne peut pas passer en sendrawid



/////////////////////////////////////////////////////////ACKS////////////////////////////////////////////////////////////
#define ACKNOWLEDGE_BALISE 0x100  // Acknowledge balise
#define ACKNOWLEDGE_MOTEUR 0x101  // Acknowledge moteur
#define ACKNOWLEDGE_IHM 0x102  // Acknowledge ecran tactile
#define ACKNOWLEDGE_ACTIONNEURS 0x103  // Acknowledge actionneurs
#define ACKNOWLEDGE_POMPES 0x104  // Acknowledge pompes
#define ACKNOWLEDGE_TELEMETRE 0x105 // Acknowledge telemetre
#define ACKNOWLEDGE_HERKULEX 0x106 // Ack ax12
#define ACKNOWLEDGE_STRAT 0x10A  // Acknowledge pompes
#define ACKNOWLEDGE_CAMERA 0x108 //Acknowledge couleur caméra


#define INSTRUCTION_END_BALISE 0x110  // Fin instruction balise  (Indique que l'instruction est terminée)
#define INSTRUCTION_END_MOTEUR 0x111  // Fin instruction moteur  (Indique que l'instruction est terminée)
#define INSTRUCTION_END_IHM 0x112  // Fin instruction ecran tactile  (Indique que l'instruction est terminée)
#define INSTRUCTION_END_ACTIONNEURS 0x113  // Fin instruction actionneurs  (Indique que l'instruction est terminée)
#define ACK_FIN_ACTION 0x116



/////////////////////////////////////////////////////////ERREURS////////////////////////////////////////////////////////
#define ERROR_OVERFLOW_BALISE 0x040  // Overflow odométrie
#define ERROR_OVERFLOW_MOTEUR 0x041  // Overflow asservissement
#define ERROR_OVERFLOW_IHM 0x042  // Overflow balise
#define ERROR_OVERFLOW_STRAT 0x043  // Overflow stratégie
#define ERROR_BALISE 0x785  // Bug balise
#define ERROR_RTC 0x786  // Bug RTC
#define ERROR_MOTEUR 0x787  // Bug moteur
#define ERROR_TELEMETRIE 0x788  // Bug télémètre
#define ERROR_STRATEGIE 0x789  // Bug stratégie



/////////////////////////////////////////////////ACTIONS SIMPLES DU ROBOT/////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//#define BAISSER_ATTRAPE_BLOC 0x220
#define RELEVER_ATTRAPE_BLOC 0x221

#define GABARIT_PETIT_ROBOT 0x200

#define PRESENTOIR_AVANT 0x201
#define PRESENTOIR_ARRIERE 0x202

#define BALANCE_AVANT 0x203
#define BALANCE_ARRIERE 0x204

#define ACCELERATEUR_AVANT 0x205
#define ACCELERATEUR_ARRIERE 0x206

#define GOLDENIUM_AVANT 0x207
#define GOLDENIUM_ARRIERE 0x208

#define SOL_AVANT 0x209
#define SOL_ARRIERE 0x210

#define SOL_AVANT_RELACHE 0x211
#define SOL_ARRIERE_RELACHE 0x212

#define AVANT_RELACHE 0x213
#define ARRIERE_RELACHE 0x214

#define RECROQUEVILLER 0x215

#define VENTOUSE_AV_CENTRE_BALANCE 0x216
#define VENTOUSE_AR_CENTRE_BALANCE 0x217

#define ACCELERATEUR_INSERTION_AVANT_GAUCHE 0X218
#define ACCELERATEUR_INSERTION_DERRIERE_GAUCHE 0X219

//commande pompe
#define HACHEUR_GET_ATOM            0x520
#define HACHEUR_GET_ATOM_ACK        0x521

#define HACHEUR_RELEASE_ATOM 0x522
#define HACHEUR_RELEASE_ATOM_ACK 0x523

#define HACHEUR_GET_PRESENTOIR_AV   0x524
#define HACHEUR_RELEASE_AV          0x525

#define HACHEUR_GET_PRESENTOIR_AR   0x526
#define HACHEUR_RELEASE_AR          0x527

#define HACHEUR_STATUT_VENTOUSES    0x528

//#define BAISSER_ATTRAPE_BLOC_AvG 0x222
#define RELEVER_ATTRAPE_BLOC_AvG 0x223

#define BAISSER_ATTRAPE_BLOC_AvD 0x224
#define RELEVER_ATTRAPE_BLOC_AvD 0x225

#define INTER_BAISSER_ATTRAPE_BLOC_AvG 0x226
#define INTER_BAISSER_ATTRAPE_BLOC_AvD 0x227

#define RANGER_ATTRAPE_BLOC_AvD 0x228
#define RANGER_ATTRAPE_BLOC_AvG 0x229

#define BRAS_VENTOUSE_1 0x22A
#define BRAS_VENTOUSE_2 0x22B

#define BRAS_ABEILLE_UP 0x202
#define BRAS_ABEILLE_DOWN 0x203
#define INCLINAISON_CHATEAU 0x204
#define INCLINAISON_EPURATION 0x205
#define ALLUMER_PANNEAU_UP 0x206
#define ALLUMER_PANNEAU_DOWN 0x207
#define BLOCAGE_BALLE 0x208
#define LANCEMENT_MOTEUR_TIR_ON 0x209
#define LANCEMENT_MOTEUR_TIR_OFF 0x20A
#define AIGUILLEUR_CENTRE 0x20B
#define AIGUILLEUR_GAUCHE 0x20C
#define AIGUILLEUR_DROITE 0x20D
#define TRI_BALLE 0x20E
#define NO_BLOC 0x20F

///////////////////////////////////////////CAPTEURS///////////////////////////////////////////////////////////////////
#define DATA_TELEMETRE 0x310        // Demande sa valeur à un télémètre parmis les 
#define RECEPTION_DATA 0x311        // envoi de la valeur d'un des télémètres
#define TELEMETRE_OBJET 0x312
#define OBJET_SUR_TABLE 0x313
#define RECEPTION_RECALAGE 0x315    //Valeur des télémètres 
#define DATA_RECALAGE 0x316         //Demande de la valeur de tous les télémètres afin de procèder au récalage
#define LIRE_PANNEAU 0x317
#define VIBRO 0x318


#define DATA_TELEMETRE_LOGIQUE 0x319
#define RECEPTION_TELEMETRE_LOGIQUE 0x320
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////ENVOI DE PARAMETRES//////////////////////////////////////////////////
#define CHOICE_COLOR 0x602  // Couleur  (0->VERT;1->ORANGE)
#define RECEPTION_COULEUR 0x603 //Code Couleur
#define ECRAN_ALL_CHECK 0x620  // Carte all check  (Si provient de carte strat => toutes les cartes sont en ligne, Si provient IHM => forcer le lancement)

///////////////////////////////////////////////////////////DEBUGS///////////////////////////////////////////////////////
#define DEBUG_STRATEGIE_AUTOMATE 0x760  // Etat automate stratégie  (Permet de savoir l'etat de l'automate)
#define DEBUG_FAKE_JAKE 0x761  // Fake jack  (Permet d'outre passerr le JACk du robot)
#define DEBUG_ASSERV 0x762  // Info debug carte moteur



#define POMPE_PWM 0x9A  // pwm des pompes  (pwm entre 0 et 100)


#define ASSERVISSEMENT_INFO_CONSIGNE 0x1F0  // Info Consigne et Commande moteur
#define ASSERVISSEMENT_CONFIG_KPP_DROITE 0x1F1  // Config coef KPP_Droit
#define ASSERVISSEMENT_CONFIG_KPI_DROITE 0x1F2  // Config coef KPI_Droit
#define ASSERVISSEMENT_CONFIG_KPD_DROITE 0x1F3  // Config coef KPD_Droit
#define ASSERVISSEMENT_CONFIG_KPP_GAUCHE 0x1F4  // Config coef KPP_Gauche
#define ASSERVISSEMENT_CONFIG_KPI_GAUCHE 0x1F5  // Config coef KPI_Gauche
#define ASSERVISSEMENT_CONFIG_KPD_GAUCHE 0x1F6  // Config coef KPD_Gauche
#define ASSERVISSEMENT_ENABLE 0x1F7  // Activation asservissement  (0 : désactivation, 1 : activation)
    
#endif
