#include "global.h"
#ifdef ROBOT_BIG


unsigned char isStopEnable = 1;//Permet de savoir si il faut autoriser le stop via les balises

/****************************************************************************************/
/* FUNCTION NAME: doFunnyAction                                                         */
/* DESCRIPTION  : Permet de faire la funny action en fin de partie                      */
/****************************************************************************************/
void doFunnyAction(void) {
    //envoie de la funny action
    // 0x007, 01, 01
        CANMessage msgTx=CANMessage();
        msgTx.id=GLOBAL_FUNNY_ACTION;
        msgTx.format=CANStandard;
        msgTx.type=CANData;
        msgTx.len=2;
        msgTx.data[0]=0x01;
        msgTx.data[1]=0x01;
        can1.write(msgTx);
}

/****************************************************************************************/
/* FUNCTION NAME: doAction                                                              */
/* DESCRIPTION  : Effectuer une action specifique                                       */
/****************************************************************************************/
unsigned char doAction(unsigned char id, unsigned short var1, short var2) {
    CANMessage msgTx=CANMessage();
    msgTx.format=CANStandard;
    msgTx.type=CANData;
    //affichage_debug(id);

    switch(id) {
        /////////////////////////////////////////////////////////100 à 108 : ACTIONS HERKULEX/////////////////////////////////////////////
        /*case 100: //Monte l'immeuble selon le code couleur
            msgTx.id=MONTER_IMMEUBLE_DOUBLE;
            
            msgTx.len=3;
            msgTx.data[0]=couleur1;
            msgTx.data[1]=couleur2;
            msgTx.data[2]=couleur3;
            can2.write(msgTx);
            break;
        
        case 101: //baisser l'attrape bloc arrière
            //SendRawId(BAISSER_ATTRAPE_BLOC);
            break;
        case 102: //Relever l'attrape bloc arrière
            //SendRawId(RELEVER_ATTRAPE_BLOC);
            break;
        case 103: //
            //SendRawId(BAISSER_ATTRAPE_BLOC_AvG);
            break;
        case 104:
            //SendRawId(RELEVER_ATTRAPE_BLOC_AvG);
            break;
        case 105:
            //SendRawId(BAISSER_ATTRAPE_BLOC_AvD);
            break;
        case 106:
            //SendRawId(RELEVER_ATTRAPE_BLOC_AvD);
            break;
        case 107:
            msgTx.id=MONTER_IMMEUBLE;
            msgTx.len=4;
            msgTx.data[0]=couleur1;
            msgTx.data[1]=couleur2;
            msgTx.data[2]=couleur3;
            msgTx.data[3]=var1;
            msgTx.data[4]=var2;
            can2.write(msgTx);
            break;
        case 108:
            SendRawId(INTER_BAISSER_ATTRAPE_BLOC_AvG);
            break;
        case 109:
            SendRawId(INTER_BAISSER_ATTRAPE_BLOC_AvD);
            break;
        case 111:
            SendRawId(RANGER_ATTRAPE_BLOC_AvD);
            break;
        case 112:
            SendRawId(RANGER_ATTRAPE_BLOC_AvG);
            break;
        case 113:
            msgTx.id=LIRE_PANNEAU;
            msgTx.len=1;
            msgTx.data[0]=var1;
            can2.write(msgTx);
            break;
        
        case 150:
            SCORE_GR+=var1;
            SCORE_GLOBAL=SCORE_GR+SCORE_PR;
            //liaison_Tx.envoyer_short(0x30,SCORE_GLOBAL);
            waitingAckFrom = 0;
            waitingAckID = 0;
            break;
           
            
        case 10://Désactiver le stop
            isStopEnable = 0;
        break;
        case 11://Activer le stop
            isStopEnable = 1;
        break;
        case 20://Désactiver l'asservissement
            setAsservissementEtat(0);
        break;
        case 21://Activer l'asservissement
            setAsservissementEtat(1);
        break;
        
        case 22://Changer la vitesse du robot
            SendSpeed(var1,(unsigned short)var2);
            waitingAckFrom = 0;
            waitingAckID = 0;
            wait(0.2);
        break;
        
        case 30://Action tempo
            wait_ms(var1);
            waitingAckFrom = 0;
            waitingAckID = 0;
        break;
        */
        
        /*case 40: // demande au telemetre la position d'un objet
            //SendRawId(TELEMETRE_RECHERCHE_OBJET);
            
            modeTelemetre = 1;
           
            //angle = angle /10;
            
            msgTx.id=TELEMETRE_OBJET;
            msgTx.format=CANStandard;
            msgTx.type=CANData;
            msgTx.len=1;
            // indice du module sur le terrain
            msgTx.data[0] = (unsigned char)speed;
            
            
            // x sur 2 octets
            msgTx.data[0]=(unsigned char)speed;
            msgTx.data[1]=(unsigned char)(speed>>8);
            // y sur 2 octets
            msgTx.data[2]=(unsigned char)angle;
            msgTx.data[3]=(unsigned char)(angle>>8);
            // theta signé sur 2 octets
            //msgTx.data[4]=(unsigned char)theta;
            //msgTx.data[5]=(unsigned char)(theta>>8);
            msgTx.data[4]=0;
            msgTx.data[5]=0;
            
            can1.write(msgTx);
            
        break;*/
        
       /* case 130://Lancer mouvement de sortie de la zone de départ
            msgTx.id=ACTION_BIG_DEMARRAGE;
            msgTx.format=CANStandard;
            msgTx.type=CANData;
            msgTx.len=1;
            msgTx.data[0] = (unsigned char)speed;
            can1.write(msgTx);
        break;*/
        
        default:
            return 0;//L'action n'existe pas, il faut utiliser le CAN
        
    }
    return 1;//L'action est spécifique.
    
}

/****************************************************************************************/
/* FUNCTION NAME: initRobot                                                             */
/* DESCRIPTION  : initialiser le robot                                                  */
/****************************************************************************************/
void initRobot(void) 
{
    //Enregistrement de tous les AX12 présent sur la carte
    /*AX12_register(5,  AX12_SERIAL2);
    AX12_register(18, AX12_SERIAL2);
    AX12_register(13, AX12_SERIAL2);
    AX12_register(1,  AX12_SERIAL1);
    AX12_register(11,  AX12_SERIAL1);
    AX12_register(8,  AX12_SERIAL1);
    AX12_register(7,  AX12_SERIAL2);*/
    
    //AX12_setGoal(AX12_ID_FUNNY_ACTION, AX12_ANGLE_FUNNY_ACTION_CLOSE,AX12_SPEED_FUNNY_ACTION);
    //AX12_processChange();
    //runRobotTest();
    
}

/****************************************************************************************/
/* FUNCTION NAME: initRobotActionneur                                                   */
/* DESCRIPTION  : Initialiser la position des actionneurs du robot                      */
/****************************************************************************************/
void initRobotActionneur(void)
{
    /*doAction(100,1,0);  
    doAction(100,2,0);
    doAction(110,0,0);
    doAction(120,0,0);
    doAction(131,0,0);*/
    
}

/****************************************************************************************/
/* FUNCTION NAME: runTest                                                               */
/* DESCRIPTION  : tester l'ensemble des actionneurs du robot                            */
/****************************************************************************************/
void runRobotTest(void) 
{
    /*
    int waitTime = 500;
    
    //Test des AX12 dans l'ordre
    doAction(111,0,0);//Fermeture pince arrière haute
    wait_ms(waitTime);
    doAction(110,0,0);//Ouverture pince arrière haute
    wait_ms(waitTime);
    doAction(113,0,0);//Fermeture pince arrière basse
    wait_ms(waitTime);
    doAction(112,0,0);//Ouverture pince arrière basse
    wait_ms(waitTime);
    doAction(115,0,0);//Fermeture porte arrière
    wait_ms(waitTime);
    doAction(114,0,0);//Ouverture porte arrière
    wait_ms(waitTime);
    doAction(101,0,0);//Fermer les portes avant
    wait_ms(waitTime);
    doAction(100,0,0);//Ouvrir les portes avant
    wait_ms(waitTime);
    doAction(103,0,0);//Descendre le peigne
    wait_ms(waitTime);
    doAction(102,0,0);//Remonter le peigne*/
}

/****************************************************************************************/
/* FUNCTION NAME: SelectStrategy                                                        */
/* DESCRIPTION  : Charger le fichier de stratégie correspondante à un id                */
/* RETURN       : 0=> Erreur, 1=> OK si le fichier existe                               */
/****************************************************************************************/
/*int SelectStrategy(unsigned char id)
{
    switch(id)
    {
        // strat de match
        case 1:
            strcpy(cheminFileStart,"/local/strat1.txt");
            return FileExists(cheminFileStart);
        case 2:
            strcpy(cheminFileStart,"/local/strat2.txt");
            return FileExists(cheminFileStart);
        case 3:
            strcpy(cheminFileStart,"/local/strat3.txt");
            return FileExists(cheminFileStart);
        case 4:
            strcpy(cheminFileStart,"/local/strat4.txt");
            return FileExists(cheminFileStart);
        case 5:
            strcpy(cheminFileStart,"/local/strat5.txt");
            return FileExists(cheminFileStart);
        case 6:
            strcpy(cheminFileStart,"/local/strat6.txt");
            return FileExists(cheminFileStart);
        case 7:
            strcpy(cheminFileStart,"/local/strat7.txt");
            return FileExists(cheminFileStart);
        case 8:
            strcpy(cheminFileStart,"/local/strat8.txt");
            return FileExists(cheminFileStart);
        case 9:
            strcpy(cheminFileStart,"/local/strat9.txt");
            return FileExists(cheminFileStart);
        case 10:
            strcpy(cheminFileStart,"/local/strat10.txt");
            return FileExists(cheminFileStart);
        
        // strat de demo
        case 0x10:
            strcpy(cheminFileStart,"/local/moteur.txt");
            return FileExists(cheminFileStart);
        case 0x11:
#ifdef ROBOT_BIG
            strcpy(cheminFileStart,"/local/bras.txt");
#else
            strcpy(cheminFileStart,"/local/porteAvant.txt");
#endif
            return FileExists(cheminFileStart);
        case 0x12:
#ifdef ROBOT_BIG
            strcpy(cheminFileStart,"/local/balancier.txt");
#else
            strcpy(cheminFileStart,"/local/mainTourneuse.txt");
#endif
            return FileExists(cheminFileStart);
        default:
            strcpy(cheminFileStart,"/local/strat1.txt");
            return 0;
    }
}*/

/****************************************************************************************/
/* FUNCTION NAME: needToStop                                                            */
/* DESCRIPTION  : Savoir si il faut autoriser le stop du robot via balise               */
/****************************************************************************************/
unsigned char needToStop(void)
{
    return isStopEnable;
}

/****************************************************************************************/
/* FUNCTION NAME: doBeforeEndAction                                                     */
/* DESCRIPTION  : Terminer les actions du robot 1s avant la fin du match                */
/****************************************************************************************/
void doBeforeEndAction(void)
{
    doAction(110,0,0);//Ouverture pince arrière haute
    doAction(112,0,0);//Ouverture pince arrière basse
    doAction(114,0,0);//Ouverture porte arrière
    doAction(100,0,0);//Ouvrir les portes avant
    doAction(102,0,0);//Remonter le peigne
}

#endif
