#include "Evitement.h"

#include <stdlib.h>
#include <string.h>
#include <math.h>

/////////////////////////////DEBUT D'UNE EBAUCHE DE CARTOGRAPHIE DU TERRAIN EN MODE DAMMIER AFIN DE PRATIQUER UN A* EN EVITEMENT/////////////////////////////////////////////////

    
/////////////////////ROBOTS/////////////////////////////////////////////
#ifdef ROBOT_BIG
    S_obstacle robot{
        0,
        0,
        6,
        6,
        0,
        0,
    };
#else
    S_obstacle robot{
        210,
        285,
        4,
        4,
        0,
        0,
    };
#endif
/////////////////////LISTE DES OBSTACLES/////////////////////////////////
S_obstacle bloc1{
    500,  //x
    800,  //y
    2,  //largeur axe X
    2,  //longueur axe Y
    1,  //danger 
    0,  //rayonnement distance à laquelle il y a un possible danger
};

S_obstacle bloc2{
    500,  //x
    2150,  //y
    2,  //largeur axe X
    2,  //longueur axe Y
    1,  //danger 
    0,  //rayonnement distance à laquelle il y a un possible danger
};

S_obstacle bloc3{
    1100,  //x
    200,  //y
    2,  //largeur axe X
    2,  //longueur axe Y
10,  //danger 
    0,  //rayonnement distance à laquelle il y a un possible danger
};

S_obstacle bloc4{
    1100,  //x
    2600,  //y
    2,  //largeur axe X
    2,  //longueur axe Y
    1,  //danger 
    0,  //rayonnement distance à laquelle il y a un possible danger
};

S_obstacle bloc5{
    1400,  //x
    1000,  //y
    2,  //largeur axe X
    2,  //longueur axe Y
    1,  //danger 
    0,  //rayonnement distance à laquelle il y a un possible danger
};

S_obstacle bloc6{
    1400,  //x
    1800,  //y
    2,  //largeur axe X
    2,  //longueur axe Y
    1,  //danger 
    0,  //rayonnement distance à laquelle il y a un possible danger
};

S_obstacle liste_objets[6]={bloc1,bloc2,bloc3,bloc4,bloc5,bloc6};



void Terrain_init(char **Table){
    int x,y;
    for(x=0;x<TAILLE_TABLE_X/TAILLE_CELLULE;x++){
        for(y=0;y<TAILLE_TABLE_Y/TAILLE_CELLULE;y++){
            Table[x][y]=1;
        }
    }
}

void Terrain_actualisation(char **Table, struct S_obstacle *liste_objet){
    int x=0,y=0,i=0;
    x=liste_objet[i].x/TAILLE_CELLULE;
    y=liste_objet[i].y/TAILLE_CELLULE;
    
    for(i=0; i<nb_objets;i++){
        while(x<(x+liste_objet[i].largeur)){ 
        
            y=liste_objet[i].y/TAILLE_CELLULE;
            
            while(y<(y+liste_objet[i].longueur)){ 
                Table[x][y]=liste_objet[i].danger;
                y++;
            }
            x++;
        }
    }   
}

void Actualisation_robot(short x,short y, short theta){
    robot.x=x;
    robot.y=y;
}
    

void Actualisation_position(char **Table){
    short x,y;
    #ifdef ROBOT_SMALL
        x=(robot.x-115)/TAILLE_CELLULE;
        y=(robot.y-115)/TAILLE_CELLULE;
    #else
        x=(robot.x-185)/TAILLE_CELLULE;
        y=(robot.y-185)/TAILLE_CELLULE;
    #endif
    while(x<(x+robot.largeur)){ 
        y=robot.y/TAILLE_CELLULE;
            
        while(y<(y+robot.longueur)){ 
            Table[x][y]=robot.danger;
            y++;
        }
        x++;
    }
}

void Actualisation_objets(char **Table,S_obstacle bloc, short x_bloc, short y_bloc){    //déplacement des cubes
    int x=0,y=0;
    x=bloc.x/TAILLE_CELLULE;
    y=bloc.y/TAILLE_CELLULE;
    
    while(x<(x+bloc.largeur)){ 
    
        y=bloc.y/TAILLE_CELLULE;
        
        while(y<(y+bloc.longueur)){ 
            Table[x][y]=1;
            y++;
        }
        x++;
    }
    
    bloc.x=x_bloc;  
    bloc.y=y_bloc;  
    x=bloc.x/TAILLE_CELLULE;
    y=bloc.y/TAILLE_CELLULE;
    
    while(x<(x+bloc.largeur)){ 
    
        y=bloc.y/TAILLE_CELLULE;
        
        while(y<(y+bloc.longueur)){ 
            Table[x][y]=1;
            y++;
        }
        x++;
    }
}    
void Localisation_robot_adv(char **Table){
}

/*void Automate_evitement(char **Table, S_obstacle robot, ){
    
    switch(EvitEtat){
        case ETAT_INIT_EVITEMENT:
            break;
            
        case ETAT_ESTIMATION_POSITION :
            break;
            
        case ETAT_ESTIMATION_POSITION_ROTATION_ACK:
            break;
            
        case ETAT_ESTIMATION_POSITION_ROTATION_ACK_END:
            break;
            
        case ETAT_FIN_EVITEMENT:
            break;
    }
}*/