#include "global.h"

CAN can1(p30,p29); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN

extern "C" void mbed_reset();//Pour pouvoir reset la carte

DigitalOut led1(LED1);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led2(LED2);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led3(LED3);//Led d'indication de problème, si elle clignote, c'est pas bon
DigitalOut led4(LED4);//Led d'indication de problème, si elle clignote, c'est pas bon

/****************************************************************************************/
/* FUNCTION NAME: canRx_ISR                                                             */
/* DESCRIPTION  : Interruption en réception sur le CAN                                  */
/****************************************************************************************/
void canRx_ISR (void)
{
    if (can1.read(msgRxBuffer[FIFO_ecriture])) {
        if(msgRxBuffer[FIFO_ecriture].id==RESET_STRAT) mbed_reset();
        else FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
    }
}


/**********************************************************************************/
/* FUNCTION NAME: main                                                            */
/* DESCRIPTION  : Fonction principal du programme                                 */
/**********************************************************************************/
int main() {
    can1.frequency(1000000); // fréquence de travail 1Mbit/s
    can1.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    
    
    wait_ms(5000);
#ifdef ROBOT_BIG
    tactile_printf("Initialisation gros robot");
#else
    tactile_printf("Initialisation petit robot");
#endif
    led1 = 1;
    initRobot();//Initialisation du robot
    initRobotActionneur();
    led1 = 0;
    wait_ms(2000);//Attente pour que toutes les cartes se lancent et surtout le CANBlue
 
    /**
    A retirer lors de l'utilisation avec selecteur de stratégie sur IHM
    **/
    //strcpy(cheminFileStart,"/local/test.txt");//On ouvre le fichier test.txt
    //loadAllInstruction();//Mise en cache de toute les instructions

    while(true) {
        automate_process();//Boucle dans l'automate principal
        canProcessRx();//Traitement des trames CAN en attente 
        //AX12_doLoop();//Vérification de la position des AX12
    }
}
