#ifndef CRAC_PERIPHERIQUES
#define CRAC_PERIPHERIQUES

#include "global.h"

#define VITESSE 700
#define TIME 0.01
#define T_MOT 0.00005


#define AX12_PINCE_CENTRALE_POSITION_INITIALE 1
#define AX12_PINCE_CENTRALE_PREPARATION_PRISE 2
#define AX12_PINCE_CENTRALE_PRISE_MODULE 3
#define AX12_PINCE_CENTRALE_STOCKAGE_HAUT 4
#define AX12_PINCE_CENTRALE_STOCKAGE_BAS 5
#define AX12_PINCE_CENTRALE_PREPARATION_DEPOT 6
#define AX12_PINCE_CENTRALE_DEPOSER 7
#define AX12_PINCE_CENTRALE_DEPOT_HAUT 8

#define AX12_GAUCHE_CROC_OUVERT 11
#define AX12_GAUCHE_CROC_FERME 12
#define AX12_DROIT_CROC_INITIALE 13


#define AX12_DROIT_CROC_OUVERT 14
#define AX12_DROIT_CROC_FERME 15
#define AX12_GAUCHE_CROC_INITIALE 16

#define AX12_TOURNANTE_GAUCHE_POSITION_INITIALE 21
#define AX12_TOURNANTE_GAUCHE_PREPARATION 22
#define AX12_TOURNANTE_GAUCHE_MODULE 23

#define AX12_TOURNANTE_DROIT_POSITION_INITIALE 24
#define AX12_TOURNANTE_DROIT_PREPARATION 25
#define AX12_TOURNANTE_DROIT_MODULE 26

#define AX12_POSITION 100
#define AX12_DEFAUT 0

#define AX12_DOIGT 4
#define AX12_BASE 5
#define AX12_COUDE 6
#define AX12_PINCEG 7
#define AX12_PINCED 8
#define AX12_GAUCHE_EPAULE 1
#define AX12_GAUCHE_COUDE 2
#define AX12_DROIT_EPAULE 9
#define AX12_DROIT_COUDE 10

#define TOLERANCE_AX12 50
               
         /*       PROTOTYPES DE FONCTIONS ET POINTEURS       */
                    


/****************************************************************************************/
/* FUNCTION NAME: Fin_action                                                            */
/* DESCRIPTION  : Fonction qui confirme la fin de mouvement des AX12                    */
/****************************************************************************************/
void Fin_action(void);


/****************************************************************************************/
/* FUNCTION NAME: Initialisation_position                                               */
/* DESCRIPTION  : Fonction qui place les bras en position verticale                     */
/****************************************************************************************/
void Initialisation_position(unsigned char choix);

void mvtBrasCentralPR(unsigned char ID1, unsigned short GSpeed1, unsigned short GPosition1, 
                              unsigned char ID2, unsigned short GSpeed2, unsigned short GPosition2,
                              unsigned char ID3, unsigned short GSpeed3, unsigned short GPosition3,
                              unsigned char ID4, unsigned short GSpeed4, unsigned short GPosition4,
                              unsigned char ID5, unsigned short GSpeed5, unsigned short GPosition5);
                              
void mvtBrasGauchePR(unsigned char ID1, unsigned short GSpeed1, unsigned short GPosition1, 
                              unsigned char ID2, unsigned short GSpeed2, unsigned short GPosition2);                              
                        
void mvtBrasDroitPR(unsigned char ID1, unsigned short GSpeed1, unsigned short GPosition1, 
                    unsigned char ID2, unsigned short GSpeed2, unsigned short GPosition2);  

void initialisation_AX12(void);

void AX12_automate(unsigned char etat_ax12);

/*********************************************************************************************************/
/* FUNCTION NAME: moteurGauchePWM                                                                        */
/* DESCRIPTION  : bouge le moteur gauche                                                                 */
/*********************************************************************************************************/
void moteurGauchePWM(float pwm);

/*********************************************************************************************************/
/* FUNCTION NAME: moteurDroitPWM                                                                        */
/* DESCRIPTION  : bouge le moteur gauche                                                                 */
/*********************************************************************************************************/
void moteurDroitPWM(float pwm);

/*********************************************************************************************************/
/* FUNCTION NAME: initMoteurs                                                                            */
/* DESCRIPTION  : init les moteurs des mains du petit robot                                              */
/*********************************************************************************************************/
void initMoteurs(void);

/*       PROTOTYPES DE FONCTIONS ET POINTEURS       */
                    
/****************************************************************************************/
/* FUNCTION NAME: Tourner_module_gauche                                                 */
/* DESCRIPTION  : Fonction qui permet de tourner les modules a gauche                   */
/****************************************************************************************/
void Tourner_module_gauche(void);

/****************************************************************************************/
/* FUNCTION NAME: Tourner_module_droit                                                  */
/* DESCRIPTION  : Fonction qui permet de tourner les modules a gauche                   */
/****************************************************************************************/
void Tourner_module_droit(void);


bool dataCouleurGauche(void);
bool dataCouleurDroit(void);
unsigned short dataTelemetre(void);
bool dataPressionGauche(void);
bool dataPressionDroit(void);

#endif
