# include "Telemetre.h"


T_MODULE listeModules[NOMBRE_OBJETS];
/*********************************************************************************************************/
/* FUNCTION NAME: SendTelemetreID                                                                        */
/* DESCRIPTION  : Envoie un message sans donnée, c'est-à-dire contenant uniquement un ID, sur le bus CAN */
/*********************************************************************************************************/
void SendTelemetreID (unsigned short id)
{
    CANMessage msgTx=CANMessage();
    msgTx.id=id;
    msgTx.len=0;
    can1.write(msgTx);
    wait_us(200);
}

/*********************************************************************************************************/
/* FUNCTION NAME: EspaceLibre                                                                            */
/* DESCRIPTION  : Calcule si la place et libre pour poser un module                                      */
/*********************************************************************************************************/
bool EspaceLibre (signed short xModule, signed short  yModule, signed short xRobot, signed short yRobot){
    return true;
    
}

/*********************************************************************************************************/
/* FUNCTION NAME: BonnePlace                                                                             */
/* DESCRIPTION  : Calcule si le module est bien placé                                                    */
/*********************************************************************************************************/
bool BonnePlace(signed short xModule, signed short  yModule, signed short xRobot, signed short yRobot){
    bool bienPlace = false;
    double distance = abs(xModule - xRobot)*abs(yModule - yRobot) + abs(yModule - yRobot)*abs(yModule - yRobot);
    
    distance = sqrt(distance);
    

    if ((TELEMETRE_PROFONDEUR - 10 < TELEMETRE_PROFONDEUR )||( TELEMETRE_PROFONDEUR + 10 > TELEMETRE_PROFONDEUR)){
        bienPlace = true;
        }
    return bienPlace;
}

void initModules(void){

    listeModules[0].x = 0;
    listeModules[0].y = 1100;
    
    listeModules[1].x = 200;
    listeModules[1].y = 950;
        
    listeModules[2].x = 600;
    listeModules[2].y = 200;
        
    listeModules[3].x = 600;
    listeModules[3].y = 1000;
        
    listeModules[4].x = 1100;
    listeModules[4].y = 500;
        
    listeModules[5].x = 1350;
    listeModules[5].y = 0;
        
    listeModules[6].x = 1400;
    listeModules[6].y = 900;
        
    listeModules[7].x = 1850;
    listeModules[7].y = 800;
        
    listeModules[8].x = 0;
    listeModules[8].y = 1850;
        
    listeModules[9].x = 200;
    listeModules[9].y = 2050;
        
    listeModules[10].x = 600;
    listeModules[10].y = 2000;
        
    listeModules[11].x = 600;
    listeModules[11].y = 2800;
    
    listeModules[12].x = 1100;
    listeModules[12].y = 2500;
    
    listeModules[13].x = 1350;
    listeModules[13].y = 0;
    
    listeModules[14].x = 1400;
    listeModules[14].y = 2100;
    
    listeModules[15].x = 1850;
    listeModules[15].y = 2200;
}

signed short returnX(int indiceTab){
    return listeModules[indiceTab].x;
    }
    
signed short returnY(int indiceTab){
    return listeModules[indiceTab].y;
    }

void processData(int objectType, signed short x, signed short y, int nb_module){
    switch(objectType){
        case CYLINDRE:
            //
        break;
        
        case MODULE:
            //
            /*if( (x == listeModules.module1.x) && (y == listeModules.module1.y) ){
                    printf("module 1");
                    listeModules.module1.timeout ++;
                }       */     
        break;
        
        case BALLE:
            //
        break;
        }
    
    }
