          #include "mbed.h"
          
CAN can(PB_8,PB_9,1000000);
Serial pc(USBTX, USBRX,9600);
DigitalIn NPN_SENSOR_0(PB_0) ;
DigitalIn PNP_SENSOR(PC_5) ;
DigitalIn NPN_SENSOR_1(PC_3) ;
DigitalIn NPN_SENSOR_2(PB_10) ; 

char get_color_sensor_data(void) ;  //retourne la valeur des capteurs sur un octet  color_sensor_data
int transfer_color_sensor_data(char sensor_data) ; //envoie l'octet de donnée sur le bus can et sur la liaison série

char get_color_sensor_data(void) {
    char color_sensor_data = 0 ;
    
    color_sensor_data = (PNP_SENSOR<<3) | ((!NPN_SENSOR_2)<<2) | ((!NPN_SENSOR_1)<<1) | (!NPN_SENSOR_0) ;    
    
    return color_sensor_data ;
    
    }
int transfer_color_sensor_data(char color_sensor_data) {
    int color_sensor_id = 0x1 ;
    char data[8] ;
    data[0] = color_sensor_data ;
    CANMessage color_sensor_msg=CANMessage(color_sensor_id,data, 1,CANData,CANStandard);
    pc.printf("\n%d",color_sensor_data) ;
    can.write(color_sensor_msg) ;
    return 0 ;
}

//PARTIE SERVO

#include "fonctions_herkulex.h"
#define TORQUE_ON                            0x60
#define POS_Gauche                           256
#define POS_Droit                            768
#define POS_Haut                             512
#define Playtime                             90
#define GLED_ON                              0x04
#define BLED_ON                              0x08
#define RLED_ON                              0x10
#define Pince_Ouvert                         200
#define Pince_Ferme                          75
#define base_initial                         750
#define base_prendre                         225
#define base_lever                           400
#define base_sortir                          400
#define base_stocker                         490
#define bras_initial                         200
#define bras_prendre                         500
#define BRAS                                 2
#define BASE                                 1
#define PINCE                                3
#define JP1                                  1
#define JP2                                  2
#define JP3                                  3
#define JP4                                  4
#define JP5                                  5
#define Vert                                 2
int couleur_gob = Vert;
uint16_t pos_initiale[3] = {base_initial,bras_initial,Pince_Ouvert};
//uint16_t pos_[3] = {base_,bras_,Pince_};
void Position_initiale(int sortie);
void prendre_gobelet(int sortie);
void poser_gobelet(int sortie);
void deverrouiller_couple(int sortie);
void ranger_gobelet(int sortie);
void sortir_gobelet(int sortie);
int automate_bras(int sortie);
void test_bras(int sortie);



int main(void)
{   
    deverrouiller_couple(JP1);
    deverrouiller_couple(JP3);
    deverrouiller_couple(JP2);
    while(true)
    {
        automate_bras(JP1);
        automate_bras(JP2);
        automate_bras(JP3);
        
    }
}
void Position_initiale(int sortie)
{
    positionControl(PINCE,Pince_Ouvert,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_sortir,Playtime,GLED_ON,sortie);
    positionControl(BRAS,bras_initial,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_initial,Playtime,GLED_ON,sortie);
}
void prendre_gobelet(int sortie)
{
    positionControl(BASE,base_sortir,Playtime,GLED_ON,sortie);
    positionControl(BRAS,bras_prendre,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_prendre,Playtime,GLED_ON,sortie);
    //wait(1);
    positionControl(PINCE,Pince_Ferme,Playtime,GLED_ON,sortie);
    //wait(1);
}
void poser_gobelet(int sortie)
{
    positionControl(BASE,base_prendre,Playtime,GLED_ON,sortie);
    positionControl(BRAS,bras_prendre,Playtime,GLED_ON,sortie);
    positionControl(PINCE,Pince_Ouvert,Playtime,GLED_ON,sortie);
}
void deverrouiller_couple(int sortie)
{
    setTorque(BASE ,TORQUE_ON ,sortie);
    setTorque(BRAS ,TORQUE_ON ,sortie);
    setTorque(PINCE ,TORQUE_ON ,sortie);
}
void ranger_gobelet(int sortie)
{
    positionControl(PINCE,Pince_Ferme,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_sortir,Playtime,GLED_ON,sortie);
    //positionControl_Mul_playtime_different(BASE, base_stocker,Playtime,GLED_ON,BRAS,bras_initial,Playtime,GLED_ON,sortie);
    positionControl(BRAS,320,Playtime,GLED_ON,sortie);
    positionControl(BASE, base_stocker,Playtime,GLED_ON,sortie);
    positionControl(BRAS,bras_initial,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_initial,Playtime,GLED_ON,sortie);
}
void sortir_gobelet(int sortie)
{
    positionControl(BASE, base_stocker,Playtime,GLED_ON,sortie);
    positionControl(BRAS,320,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_sortir,Playtime,GLED_ON,sortie);
    //positionControl_Mul_playtime_different(BASE, base_stocker,Playtime,GLED_ON,BRAS,bras_initial,Playtime,GLED_ON,sortie);
    //positionControl(BRAS,bras_initial,Playtime,GLED_ON,sortie);
    //positionControl(BASE, base_stocker,Playtime,GLED_ON,sortie);
    //positionControl(BASE,base_sortir,Playtime,GLED_ON,sortie);
    //wait(1);
    positionControl(BRAS,bras_prendre,Playtime,GLED_ON,sortie);
    positionControl(BASE,base_prendre,Playtime,GLED_ON,sortie);
    //wait(1);
    positionControl(PINCE,Pince_Ouvert,Playtime,GLED_ON,sortie);
}
void test_bras(int sortie)
{
    Position_initiale(sortie);
    prendre_gobelet(sortie);
    ranger_gobelet(sortie);
    wait(0.5);
    sortir_gobelet(sortie);
    Position_initiale(sortie);
}
int automate_bras(int sortie)
{   char couleur ;
    int masque[3] = {0x01, 0x02,0x04} ;
    Position_initiale(sortie);
    prendre_gobelet(sortie);
    ranger_gobelet(sortie);
    wait(0.5);
    couleur = get_color_sensor_data() ;
    transfer_color_sensor_data(couleur) ;
    if(couleur &masque[sortie-1])
    { 
        sortir_gobelet(sortie);
        Position_initiale(sortie);
    }
}
    




