#include "mbed.h"
#include "ident_crac.h"
#include "lib.h"

#define SIZE_FIFO               50 //Taille du buffer pour le bus CAN
 
AnalogIn analog_value(A0);
 
DigitalOut led(LED1);

void canProcessRx(void);
unsigned char FIFO_ecriture=0; //Position du fifo pour la reception CAN
signed char FIFO_lecture=0;//Position du fifo de lecture des messages CAN

CAN can1(PB_8,PB_9); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en r�ception pour le CAN

void canRx_ISR (void)
{
    if (can1.read(msgRxBuffer[FIFO_ecriture])) {
        //if(msgRxBuffer[FIFO_ecriture].id==RESET_STRAT) mbed_reset();
        /*else*/ FIFO_ecriture=(FIFO_ecriture+1)%SIZE_FIFO;
    }
}

int Combinaison_cube = 0;

int main() {
    
    can1.frequency(1000000); // fr�quence de travail 1Mbit/s
    can1.attach(&canRx_ISR); // cr�ation de l'interrupt attach�e � la r�ception sur le CAN
    
    wait_ms(500);
    
    while(1) {
        canProcessRx();
    }
}

void canProcessRx(void)
{           
    static signed char FIFO_occupation=0,FIFO_max_occupation=0;
    CANMessage msgTx=CANMessage();
    FIFO_occupation=FIFO_ecriture-FIFO_lecture;
    if(FIFO_occupation<0)
        FIFO_occupation=FIFO_occupation+SIZE_FIFO;
    if(FIFO_max_occupation<FIFO_occupation)
        FIFO_max_occupation=FIFO_occupation;
    if(FIFO_occupation!=0) {
        
        switch(msgRxBuffer[FIFO_lecture].id) {
            case DEBUG_FAKE_JAKE://Permet de lancer le match � distance
            case GLOBAL_JACK:
            break;
            case ALIVE_BALISE:
            case ALIVE_MOTEUR:
            case ALIVE_IHM:
            case ALIVE_ACTIONNEURS_AVANT:
            case ALIVE_ACTIONNEURS_ARRIERE:
            case ALIVE_AX12:
            case ECRAN_ALL_CHECK:
            break; 
            case ACKNOWLEDGE_BALISE:
            case ACKNOWLEDGE_MOTEUR:
            case ACKNOWLEDGE_IHM:
            case ACKNOWLEDGE_TELEMETRE:
            case ACKNOWLEDGE_AX12:
            case INSTRUCTION_END_BALISE:
            case INSTRUCTION_END_MOTEUR:
            case INSTRUCTION_END_IHM:
            case INSTRUCTION_END_AX12:
            break;
            case ECRAN_START_MATCH:
            break;
            case SERVO_AX12_PROCESS:
            break;
            case SERVO_AX12_DONE:
            break;
            case ECRAN_CHOICE_COLOR:
            break;
            case ECRAN_CHOICE_STRAT:
            break;
            case BALISE_DANGER :
            break;
            case BALISE_STOP:
            break;
            case BALISE_END_DANGER:
            break;
            
            case ECRAN_CHOICE_START_ACTION:
            break;
            case OBJET_SUR_TABLE:
            break;
            case Monter_immeuble:
                unsigned char Combinaison_cube_1 = msgRxBuffer[FIFO_lecture].data[0];
                unsigned char Combinaison_cube_2 = msgRxBuffer[FIFO_lecture].data[1];
                unsigned char Combinaison_cube_3 = msgRxBuffer[FIFO_lecture].data[2];
                monter_immeble(1,Combinaison_cube_1,Combinaison_cube_2,Combinaison_cube_3);
            break;
        }        
        
        FIFO_lecture=(FIFO_lecture+1)%SIZE_FIFO;
    }
}