#include "bloc_8_pompe.h"

//initialisations relatives au Bus CAN
CAN bus_CAN(PB_8, PB_9, 1000000) ;
CANMessage commande_carte ;
CANMessage envoie ;
int flag_reception_CAN = 0 ;
Timer scoreTimer;
void interruption_reception(void) ;
void gestion_Message_CAN(void) ;
void Envoi_msg_CAN(char donnee[6]);
void initialisation_CAN(void) ;
void ventouse_etat(void);
void SendRawId (unsigned short id);

//Fin de jeu
char end_game = 0;

bloc_8_pompe::bloc_8_pompe classe_pompe    (PC_9, PA_8, PB_0,       //bloc 1
                                            PB_7, PA_10, PB_1,      //bloc 2
                                            PA_11, PA_15, PC_1,     //bloc 3
                                            PA_9, PB_6, PC_0,       //bloc 4
                                            PC_7, PC_8, PC_5,       //bloc 5
                                            PB_10, PB_2, PC_4,      //bloc 6
                                            PA_6, PA_5, PA_7,       //bloc 7
                                            PA_0, PA_1, PA_4);      //bloc 8

int main()
{    
    bus_CAN.attach(&interruption_reception) ;
    static int old_Timer=0;
    initialisation_CAN() ;
    
    scoreTimer.start();
    
    while(1)
    {
        //bus_CAN(envoie); 
        if(flag_reception_CAN)
        {
            gestion_Message_CAN() ;
        }
        
        if(end_game)
        {
            for (int i=0 ; i<8 ; i++)
            {
                classe_pompe.stop_pompe(i);
                wait_ms(10) ;
            }
        }
        
        ventouse_etat();
        
        //Appelle toutes les 100ms pour regarder l'état des pompes
        /*
        if((scoreTimer.read_ms()-old_Timer)>=100)
        {
            ventouse_etat();
            old_Timer=scoreTimer.read_ms();
        } 
       */ 
        //Envoi_msg_CAN(1); //envoie un msg pour tester la liaison can
    }
        
}

void interruption_reception(void) 
{
    if (bus_CAN.read(commande_carte))
        flag_reception_CAN = 1 ;
}

void gestion_Message_CAN(void) 
{
    int identifiant = commande_carte.id ;
    char num_groupe = 1 ;
    char etat_groupe = 0 ;
    
    switch (identifiant) 
    {
        case VENT_AT:
                num_groupe = commande_carte.data[0];
                if(num_groupe<6)
                {
                    if(num_groupe == 0) num_groupe = 3;
                    else if (num_groupe == 1) num_groupe = 2;
                    else if (num_groupe == 2) num_groupe = 1;
                    else if (num_groupe == 3) num_groupe = 5;
                    else if (num_groupe == 4) num_groupe = 6;
                    else if (num_groupe == 5) num_groupe = 7;
                    classe_pompe.aspirer(num_groupe);
                }
                else if(num_groupe>5)
                {
                    switch(num_groupe)
                    {
                    case 10:
                        classe_pompe.aspirer(2);                       
                        classe_pompe.aspirer(3);
                    break;

                    case 20:
                        classe_pompe.aspirer(1);
                        classe_pompe.aspirer(3);
                    break;

                    case 21:
                        classe_pompe.aspirer(2);
                        classe_pompe.aspirer(1);
                    break;

                    case 210:
                        classe_pompe.aspirer(3);                  
                        classe_pompe.aspirer(2); 
                        classe_pompe.aspirer(1);
                    break;

                    case 43:
                        classe_pompe.aspirer(5);
                        classe_pompe.aspirer(6);
                    break;

                    case 53:
                        classe_pompe.aspirer(5);
                        classe_pompe.aspirer(7);
                    break;

                    case 54:
                        classe_pompe.aspirer(7);
                        classe_pompe.aspirer(6);
                    break;

                    case 66:
                        classe_pompe.aspirer(7);
                        classe_pompe.aspirer(6);
                        classe_pompe.aspirer(5);
                    break;
                    }
                }
                break;
                
        case VENT_RE:
                num_groupe = commande_carte.data[0];
                if(num_groupe<6)
                {
                    if(num_groupe == 0) num_groupe = 3;
                    else if (num_groupe == 1) num_groupe = 2;
                    else if (num_groupe == 2) num_groupe = 1;
                    else if (num_groupe == 3) num_groupe = 5;
                    else if (num_groupe == 4) num_groupe = 6;
                    else if (num_groupe == 5) num_groupe = 7;
                    classe_pompe.relacher(num_groupe);
                }
                else if(num_groupe>5)
                {
                    switch(num_groupe)
                    {
                    case 10:
                        classe_pompe.relacher(2);
                        classe_pompe.relacher(3);                  
                    break;

                    case 20:
                        classe_pompe.relacher(1);
                        classe_pompe.relacher(3);
                    break;

                    case 21:
                        classe_pompe.relacher(2);
                        classe_pompe.relacher(1);
                    break;

                    case 210:
                        classe_pompe.relacher(3);
                        classe_pompe.relacher(2);
                        classe_pompe.relacher(1);
                    break;

                    case 43:
                        classe_pompe.relacher(5);
                        classe_pompe.relacher(6);
                    break;

                    case 53:
                        classe_pompe.relacher(7);
                        classe_pompe.relacher(5);
                    break;

                    case 54:
                        classe_pompe.relacher(7);
                        classe_pompe.relacher(6);
                    break;

                    case 66:
                        classe_pompe.relacher(7);
                        classe_pompe.relacher(6);
                        classe_pompe.relacher(5);
                    break;
                    }
                }
                break;   
            
        case VENT_ETAT:
                num_groupe = commande_carte.data[0];
                if(num_groupe<6)
                {
                    if(num_groupe == 0) num_groupe = 3;
                    else if (num_groupe == 1) num_groupe = 2;
                    else if (num_groupe == 2) num_groupe = 1;
                    else if (num_groupe == 3) num_groupe = 5;
                    else if (num_groupe == 4) num_groupe = 6;
                    else if (num_groupe == 5) num_groupe = 7;
                }
                etat_groupe = classe_pompe.etat_actuel(num_groupe) ;
                
                if(etat_groupe == 0x07)
                {
                    classe_pompe.aspirer(num_groupe) ;
                    etat_groupe = classe_pompe.etat_actuel(num_groupe) ;
                }
                
                
                //Envoi_msg_CAN(etat_groupe);
                
                break;
            
        case GLOBAL_GAME_END:
                end_game = 1;
                break;
                

        /*        
                
        case TEST_VENT_1_ON:
                classe_pompe[AV_DROIT]->action(1);
                classe_pompe[AV_CENTRE]->action(1);
                classe_pompe[AV_GAUCHE]->action(1);
                classe_pompe[AR_DROIT]->action(1);
                classe_pompe[AR_CENTRE]->action(1);
                classe_pompe[AR_GAUCHE]->action(1);
                break;
            
        case TEST_VENT_1_OFF:
                classe_pompe[AV_CENTRE]->action(0);
                classe_pompe[AV_GAUCHE]->action(0);
                classe_pompe[AR_DROIT]->action(0);
                classe_pompe[AR_CENTRE]->action(0);
                classe_pompe[AR_GAUCHE]->action(0);
                classe_pompe[AV_DROIT]->action(0);
                break;*/
        default:
                break;        
    }
    flag_reception_CAN = 0 ;
                
}

void Envoi_msg_CAN(char donnee[6])
{   
    CANMessage etat_ventouses=CANMessage();
    etat_ventouses.id = 0x220;    
    etat_ventouses.len=6;
    etat_ventouses.type=CANData;
    for(int num_octet=0; num_octet<6; num_octet++)
    {
        etat_ventouses.data[num_octet]=donnee[num_octet];
    }
    bus_CAN.write(etat_ventouses);
}

void initialisation_CAN(void) 
{
    CANMessage msg_init;
    msg_init.id = ALIVE_ACTIONNEURS_ARRIERE;    
    msg_init.len=0;

    bus_CAN.write(msg_init);
}

void ventouse_etat(void)
{
    char num_groupe;
    char etat_groupe[6];
    static char old_etat_groupe[6] = {0,0,0,0,0,0};
    
    for(int i=0;i<6;i++)
    {
        if(i == 0) num_groupe = 3;
        else if (i == 1) num_groupe = 2;
        else if (i == 2) num_groupe = 1;
        else if (i == 3) num_groupe = 5;
        else if (i == 4) num_groupe = 6;
        else if (i == 5) num_groupe = 7;
        
        etat_groupe[i] = classe_pompe.etat_actuel(num_groupe);   
    }
    
    for(int i=0;i<6;i++)
    {
        if(old_etat_groupe[i] != etat_groupe[i])
        {
            Envoi_msg_CAN(etat_groupe);
        }
        old_etat_groupe[i] = etat_groupe[i];
    }
}


void SendRawId (unsigned short id)
{
    CANMessage msgTx;
    msgTx.id=id;
    msgTx.len=0;
    bus_CAN.write(msgTx);
} 
