#include "bloc_monopompe.h"

bloc_monopompe::bloc_monopompe (PinName pompe, PinName electrovanne, PinName capteur) 
 : _pompe(pompe), _electrovanne(electrovanne), _capteur(capteur) 
{
    _pompe.period_us(20) ;
}

void bloc_monopompe::aspirer (void) 
{
    float val_cpt;
    _pompe = PWM_POMPE ;
    _electrovanne = ELEC_OUVERTE ;
    //wait_ms(1000) ;
    val_cpt = _capteur.read() ;
    //wait_ms(100) ;
    
    if( val_cpt >= SEUIL_CPT)
    {
        _gobelet_en_place = 1 ;
    }
    else
    {
        _gobelet_en_place = 0 ;
    }
}

void bloc_monopompe::relacher (void) 
{
    if(_capteur.read() >= SEUIL_CPT)
    {
        _pompe = PWM_STOP_POMPE;
        _electrovanne = ELEC_FERME ;
        //wait_ms(100) ;
    }
    _gobelet_en_place = 0 ;
}

char bloc_monopompe::etat_actuel (void) 
{
    char etat_groupe = 0 ;
    bool etat_pompe;
    bool etat_electrovanne ;
    
    if(_pompe.read() != 0)              //test de la pompe
        etat_pompe = 1 ;
    else 
        etat_pompe = 0 ;
    
    if(_capteur.read() >= SEUIL_CPT)    //test du capteur
        _gobelet_en_place = 1 ;
    else 
        _gobelet_en_place = 0 ;
        
    if(_electrovanne.read())              //test de l'electrovanne
        etat_electrovanne = 1 ;
    else 
        etat_electrovanne = 0 ;
    
    // contenue du char : (cela evite l'utilisation de pointeurs)
    //0000 0 "bit pompe" "bit elec" "bit cpt"
    return etat_groupe = (etat_pompe << 2) + (etat_electrovanne << 1) + _gobelet_en_place ;    
}

void bloc_monopompe::stop_pompe (void)
{
    _pompe = PWM_STOP_POMPE ;
    _electrovanne = ELEC_OUVERTE ;
}