#include "all_includes.h"

Timer t;
Ticker flipper;

CAN can(p30,p29); // Rx&Tx pour le CAN
CANMessage msgRxBuffer[SIZE_FIFO]; // buffer en réception pour le CAN

Serial pc(USBTX, USBRX);

DigitalOut led(LED1);
DigitalOut led2(LED2);

unsigned char EtatAx12, ActionAx12;
unsigned char action_a_effectuer;


/*
DigitalIn IO1(p23);
DigitalIn IO2(p24);
DigitalIn IO3(p25);
DigitalIn IO4(p26);

AnalogIn A_in1(p15);
AnalogIn A_in2(p16);
AnalogIn A_in3(p17);
AnalogIn A_in4(p18);
AnalogIn A_in5(p19);
AnalogIn A_in6(p20);

PwmOut IRL_1(p21);
PwmOut IRL_2(p22);
*/



    
int main() {
    
    can.frequency(1000000); // fréquence de travail 1Mbit/s
    can.attach(&canRx_ISR); // création de l'interrupt attachée à la réception sur le CAN
    
    // message CAN autorise a declencher l'interruption
    CAN2_wrFilter(SERVO_AX12_ACTION);
    CAN2_wrFilter(SERVO_AX12_ACK);
    CAN2_wrFilter(SERVO_AX12_END);
    CAN2_wrFilter(CHECK_AX12);
              
    initialisation_AX12();
     
    //PINCE CENTRALE
    AX12_automate(AX12_PINCE_CENTRALE_POSITION_INITIALE);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_PREPARATION_PRISE);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_PRISE_MODULE);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_STOCKAGE_HAUT);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_PREPARATION_PRISE);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_PRISE_MODULE);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_STOCKAGE_BAS);
    wait(2);
    AX12_automate(AX12_PINCE_CENTRALE_PREPARATION_DEPOT);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_DEPOSER);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_DEPOT_HAUT);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_PREPARATION_DEPOT);
    wait(1);
    AX12_automate(AX12_PINCE_CENTRALE_DEPOSER);
    wait(1);

    
    //BRAS GAUCHE
    /*
    AX12_automate(AX12_GAUCHE_CROC_OUVERT);
    wait(2);
    AX12_automate(AX12_GAUCHE_CROC_FERME);
    wait(3);
    AX12_automate(AX12_GAUCHE_CROC_OUVERT);
    wait(2);    
    AX12_automate(AX12_TOURNANTE_GAUCHE_POSITION_INITIALE);
    wait(2);
    AX12_automate(AX12_TOURNANTE_GAUCHE_PREPARATION);
    wait(2);
    AX12_automate(AX12_TOURNANTE_GAUCHE_MODULE);
    wait(2);
    */
    
    /*
    //BRAS DROIT
    AX12_automate(AX12_DROIT_CROC_OUVERT);
    wait(2);
    AX12_automate(AX12_DROIT_CROC_FERME);
    wait(3);
    AX12_automate(AX12_DROIT_CROC_OUVERT);
    wait(2);
    AX12_automate(AX12_TOURNANTE_DROIT_POSITION_INITIALE);
    wait(2);
    AX12_automate(AX12_TOURNANTE_DROIT_PREPARATION);
    wait(2);
    AX12_automate(AX12_TOURNANTE_DROIT_MODULE);
    wait(2);
    */
    
    /*
    AX12_automate(AX12_DROIT_CROC_INITIALE);
    wait(2);
    AX12_automate(AX12_GAUCHE_CROC_INITIALE);
    wait(3);
    */


    while(1) {
        //AX12_automate(AX12_POSITION);
        
        led = !led;
        canProcessRx();//Traitement des trames CAN en attente 
        
        
        if (action_a_effectuer==1) {
            
            action_a_effectuer=0;
            
            if (ActionAx12==1){
                AX12_automate(EtatAx12);
                ActionAx12=0;
            }
            
        } 
    }
    
}

