#include "mbed.h"
#include "SC16IS750.h"
 
I2C i2c(p28,p27);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
char cmd[128];
char str[128];
char i, j;
 
void set_ch(char sel)
{    // PCA9541のサンプル
        // MST_0側の自分にスレーブ側の制御権を得る場合
    cmd[0] = 1;                     // PCA9541 コマンドコード Cont Reg
    i2c.write( 0xe2, cmd, 1);       // Cont Regを指定
    i2c.read( 0xe2, cmd, 1);        // Cont Regを読込み
    wait(0.1);                      // 0.1s待つ
    switch(cmd[0] & 0xf)
    {
    case 0:                         // bus off, has control
    case 1:                         // bus off, no control
    case 5:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 4;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 2:                         // bus off, no control
    case 3:                         // bus off, has control
    case 6:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 5;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 9:                         // bus on, no control
    case 0xc:                       // bus on, no control
    case 0xd:                       // bus off, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 0;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 0xa:                       // bus on, no control
    case 0xe:                       // bus off, no control
    case 0xf:                       // bus on, has control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 1;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    default:
        break;
    }

    cmd[0] = sel;                   // PCA9546 Cont Reg sel channel enabled
    i2c.write( 0xe8, cmd, 1);       // Send command string
}

int main ()
{
    i2c.frequency(100000);
    pc.printf("\r\nSC16IS750 Sample Program\r\n");
     
    set_ch(1);              // SC16IS750はch0に接続
  // 

    cmd[0] = LCR << 3;
    cmd[1] = 0x83;          // DLL,H Latch enable
    i2c.write(SC16IS750_ADDR, cmd, 2);

    cmd[0] = DLL << 3;
    cmd[1] = 117;           // baud = 18e6 / 16 /117 = 9615 
    i2c.write(SC16IS750_ADDR, cmd, 2);

    cmd[0] = DLH << 3;
    cmd[1] = 0x0;
    i2c.write(SC16IS750_ADDR, cmd, 2);

    cmd[0] = LCR << 3;
    cmd[1] = 0x03;        // NoParity 1Stop 8bits
    i2c.write(SC16IS750_ADDR, cmd, 2);

    cmd[0] = FCR << 3;
    cmd[1] = 0x07;        // reset TX,RX FIFO, FIFO enable
    i2c.write(SC16IS750_ADDR, cmd, 2);

    while(1)
    {
        pc.printf("\r\n文字列を入力してください>");
        pc.scanf("%s" , str);
        j = strlen(str);
        pc.printf("\r\n送信された文字列 = %s %d文字\r\n" , str, j);
        cmd[0] = THR << 3;
        for (i = 0; i < j; i++) cmd[i + 1] = str[i];
        i2c.write(SC16IS750_ADDR, cmd, j + 1);

        wait(1);

        cmd[0] = RHR << 3;          //
        i2c.write(SC16IS750_ADDR, cmd, 1, true);
        i2c.read(SC16IS750_ADDR, cmd, j);
        cmd[j] = 0;
        pc.printf("受信した文字列 = %s\r\n", cmd);
    }
}