#include "mbed.h"
#include "PCF8591.h"
 
I2C i2c(p28,p27);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
char cmd[32];
char i;
 
void set_ch(char sel)
{    // PCA9541のサンプル
        // MST_0側の自分にスレーブ側の制御権を得る場合
    cmd[0] = 1;                     // PCA9541 コマンドコード Cont Reg
    i2c.write( 0xe2, cmd, 1);       // Cont Regを指定
    i2c.read( 0xe2, cmd, 1);        // Cont Regを読込み
    wait(0.1);                      // 0.1s待つ
    switch(cmd[0] & 0xf)
    {
    case 0:                         // bus off, has control
    case 1:                         // bus off, no control
    case 5:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 4;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 2:                         // bus off, no control
    case 3:                         // bus off, has control
    case 6:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 5;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 9:                         // bus on, no control
    case 0xc:                       // bus on, no control
    case 0xd:                       // bus off, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 0;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 0xa:                       // bus on, no control
    case 0xe:                       // bus off, no control
    case 0xf:                       // bus on, has control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 1;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    default:
        break;
    }

    cmd[0] = sel;                   // PCA9546 Cont Reg sel channel enabled
    i2c.write( 0xe8, cmd, 1);       // Send command string
}

int main ()
{
   i2c.frequency(100000);
    pc.printf("PCF8591T Sample Program\r\n");
     
    set_ch(2);              // PCF8591Tはch1に接続

  // PCF8591T

    cmd[0] = 0x44;
    cmd[1] = 0x80;           // SLEEP = 0
    i2c.write(PCF8591_ADDR, cmd, 2);   // cmd[0]Regにcmd[1]を書込み
    pc.printf("AOUT=%2x  AIN0=%2x AIN1=%2x AIN2=%2x AIN3=%2x\r\n", i++, cmd[1], cmd[2], cmd[3], cmd[4]); // Cont Regを表示

  while(1)
  {
    cmd[0] = 0x44 + 0x0;          // DAC有効、オートインクリメント
    cmd[1] = i;             // DAC値設定 0～0xFF
    i2c.write(PCF8591_ADDR, cmd, 2);    // DAC値更新

    i2c.read(PCF8591_ADDR, cmd, 5);     // AD変換値を5バイト分取得
    // AD変換値はCH0の前回データ、CH0～CH3の変換データ
    pc.printf("AOUT=%2x  PREV=%2x AIN0=%2x AIN1=%2x AIN2=%2x AIN3=%2x\r\n", i++, cmd[0], cmd[1], cmd[2], cmd[3], cmd[4]); // AD変換値を表示
    wait(1.0);
  }
}