#include "mbed.h"
#include "PCA9956A.h"
 
I2C i2c(p28,p27);        // sda, scl
Serial pc(USBTX, USBRX); // tx, rx
char cmd[32];
int i, j;
 
void set_ch(char sel)
{    // PCA9541のサンプル
        // MST_0側の自分にスレーブ側の制御権を得る場合
    cmd[0] = 1;                     // PCA9541 コマンドコード Cont Reg
    i2c.write( 0xe2, cmd, 1);       // Cont Regを指定
    i2c.read( 0xe2, cmd, 1);        // Cont Regを読込み
    wait(0.1);                      // 0.1s待つ
    switch(cmd[0] & 0xf)
    {
    case 0:                         // bus off, has control
    case 1:                         // bus off, no control
    case 5:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 4;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 2:                         // bus off, no control
    case 3:                         // bus off, has control
    case 6:                         // bus on, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 5;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 9:                         // bus on, no control
    case 0xc:                       // bus on, no control
    case 0xd:                       // bus off, no control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 0;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    case 0xa:                       // bus on, no control
    case 0xe:                       // bus off, no control
    case 0xf:                       // bus on, has control
        cmd[0] = 1;                 // PCA9541 コマンドコード Cont Reg
        cmd[1] = 1;                 // bus on, has control
        i2c.write( 0xe2, cmd, 2);   // Cont Regにcmd[1]を書込み
        i2c.read( 0xe2, cmd, 1);    // Cont Regを読込み
        break;
    default:
        break;
    }

    cmd[0] = sel;                   // PCA9546 Cont Reg sel channel enabled
    i2c.write( 0xe8, cmd, 1);       // Send command string
}

int main ()
{
    i2c.frequency(100000);
    pc.printf("PCA9956A Sample Program\r\n");
     
    set_ch(2);              // PCA9956Aはch1に接続

  // PCA9956A
  cmd[0] = MODE1;
  cmd[1] = 0x0;           // SLEEP = 0
  i2c.write(PCA9956A_ADDR, cmd, 2);   // cmd[0]Regにcmd[1]を書込み

  cmd[0] = LEDOUT0 + 0x80;   // LEDOUT0, Auto incriment
  cmd[1] = 0xaa;          // LED3,2,1,0 10= PWM
  cmd[2] = 0xaa;          // LED7,6,5,4 10= PWM
  cmd[3] = 0xaa;          // LED11,10,9,8 10= PWM
  cmd[4] = 0xaa;          // LED15,14,13,12 10= PWM
  cmd[5] = 0xaa;          // LED19,18,17,16 10= PWM
  cmd[6] = 0xaa;          // LED23,22,21,20 10= PWM
  i2c.write(PCA9956A_ADDR, cmd, 7);   // cmd[0]Regにcmd[1-6]を書込み

  cmd[0] = IREFALL;
  cmd[1] = 0x80;        // Idrv = 40uA * 128 = 5.12mA
  i2c.write(PCA9956A_ADDR, cmd, 2);   // cmd[0]Regにcmd[1]を書込み

  while(1)
  {
    if (i>23) i = 0;
    cmd[0] = PWMALL;
    cmd[1] = 0x0;           // PWM = 0%
    i2c.write(PCA9956A_ADDR, cmd, 2);   // cmd[0]Regにcmd[1]を書込み

    cmd[0] = PWM0 + i;      // PWMx = PWM0 + i
    cmd[1] = 0xf0;          // PWM = 99.6%
    i2c.write(PCA9956A_ADDR, cmd, 2);   // cmd[0]Regにcmd[1]を書込み
    wait(0.5);
    i++;
  }
}

